/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets.amd64;

import com.oracle.svm.core.graal.nodes.VaListNextArgNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

final class PosixAMD64VaListSnippets
extends SubstrateTemplates
implements Snippets {
    private static final int GP_OFFSET_LOCATION = 0;
    private static final int NUM_GP_ARG_REGISTERS = 6;
    private static final int MAX_GP_OFFSET = 48;
    private static final int FP_OFFSET_LOCATION = 4;
    private static final int NUM_FP_ARG_REGISTERS = 8;
    private static final int MAX_FP_OFFSET = 176;
    private static final int OVERFLOW_ARG_AREA_LOCATION = 8;
    private static final int OVERFLOW_ARG_AREA_ALIGNMENT = 8;
    private static final int REG_SAVE_AREA_LOCATION = 16;

    private PosixAMD64VaListSnippets(OptionValues options, Providers providers) {
        super(options, providers);
    }

    @Snippet(allowMissingProbabilities=true)
    protected static double vaArgDoubleSnippet(Pointer vaList) {
        int fpOffset = vaList.readInt(4);
        if (fpOffset < 176) {
            Pointer regSaveArea = (Pointer)vaList.readWord(16);
            double v = regSaveArea.readDouble(fpOffset);
            vaList.writeInt(4, fpOffset + 16);
            return v;
        }
        Pointer overflowArgArea = (Pointer)vaList.readWord(8);
        double v = overflowArgArea.readDouble(0);
        vaList.writeWord(8, (WordBase)overflowArgArea.add(8));
        return v;
    }

    @Snippet
    protected static float vaArgFloatSnippet(Pointer vaList) {
        return (float)PosixAMD64VaListSnippets.vaArgDoubleSnippet(vaList);
    }

    @Snippet(allowMissingProbabilities=true)
    protected static long vaArgLongSnippet(Pointer vaList) {
        int gpOffset = vaList.readInt(0);
        if (gpOffset < 48) {
            Pointer regSaveArea = (Pointer)vaList.readWord(16);
            long v = regSaveArea.readLong(gpOffset);
            vaList.writeInt(0, gpOffset + 8);
            return v;
        }
        Pointer overflowArgArea = (Pointer)vaList.readWord(8);
        long v = overflowArgArea.readLong(0);
        vaList.writeWord(8, (WordBase)overflowArgArea.add(8));
        return v;
    }

    @Snippet
    protected static int vaArgIntSnippet(Pointer vaList) {
        return (int)PosixAMD64VaListSnippets.vaArgLongSnippet(vaList);
    }

    public static void registerLowerings(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new PosixAMD64VaListSnippets(options, providers, lowerings);
    }

    private PosixAMD64VaListSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        lowerings.put(VaListNextArgNode.class, new VaListSnippetsLowering());
    }

    protected class VaListSnippetsLowering
    implements NodeLoweringProvider<VaListNextArgNode> {
        private final SnippetTemplate.SnippetInfo vaArgDouble;
        private final SnippetTemplate.SnippetInfo vaArgFloat;
        private final SnippetTemplate.SnippetInfo vaArgLong;
        private final SnippetTemplate.SnippetInfo vaArgInt;

        protected VaListSnippetsLowering() {
            this.vaArgDouble = PosixAMD64VaListSnippets.this.snippet(PosixAMD64VaListSnippets.class, "vaArgDoubleSnippet", new LocationIdentity[0]);
            this.vaArgFloat = PosixAMD64VaListSnippets.this.snippet(PosixAMD64VaListSnippets.class, "vaArgFloatSnippet", new LocationIdentity[0]);
            this.vaArgLong = PosixAMD64VaListSnippets.this.snippet(PosixAMD64VaListSnippets.class, "vaArgLongSnippet", new LocationIdentity[0]);
            this.vaArgInt = PosixAMD64VaListSnippets.this.snippet(PosixAMD64VaListSnippets.class, "vaArgIntSnippet", new LocationIdentity[0]);
        }

        @Override
        public void lower(VaListNextArgNode node, LoweringTool tool) {
            SnippetTemplate.SnippetInfo snippet;
            switch (node.getStackKind()) {
                case Double: {
                    snippet = this.vaArgDouble;
                    break;
                }
                case Float: {
                    snippet = this.vaArgFloat;
                    break;
                }
                case Long: {
                    snippet = this.vaArgLong;
                    break;
                }
                case Int: {
                    snippet = this.vaArgInt;
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere();
                }
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("vaList", (Object)node.getVaList());
            PosixAMD64VaListSnippets.this.template((ValueNode)node, args).instantiate(PosixAMD64VaListSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

