/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.hosted.GraalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.truffle.HostedTruffleConstantFieldProvider;
import com.oracle.svm.truffle.SubstrateTruffleHostInliningPhase;
import com.oracle.svm.truffle.TruffleBaseFeature;
import com.oracle.svm.truffle.TruffleSupport;
import com.oracle.svm.truffle.api.SubstrateThreadLocalHandshake;
import com.oracle.svm.truffle.api.SubstrateThreadLocalHandshakeSnippets;
import com.oracle.svm.truffle.api.SubstrateTruffleCompiler;
import com.oracle.svm.truffle.api.SubstrateTruffleRuntime;
import com.oracle.svm.util.GuardedAnnotationAccess;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.phases.HighTier;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.BytecodeParserOptions;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.amd64.substitutions.AMD64TruffleInvocationPlugins;
import org.graalvm.compiler.truffle.compiler.nodes.asserts.NeverPartOfCompilationNode;
import org.graalvm.compiler.truffle.compiler.phases.TruffleHostInliningPhase;
import org.graalvm.compiler.truffle.compiler.substitutions.KnownTruffleTypes;
import org.graalvm.compiler.truffle.runtime.TruffleCallBoundary;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

public class TruffleFeature
implements InternalFeature {
    private final Set<ResolvedJavaMethod> blocklistMethods = new HashSet<ResolvedJavaMethod>();
    private final Set<GraalFeature.CallTreeNode> blocklistViolations = new TreeSet<GraalFeature.CallTreeNode>(TruffleFeature::blocklistViolationComparator);
    private final Set<ResolvedJavaMethod> warnMethods = new HashSet<ResolvedJavaMethod>();
    private final Set<GraalFeature.CallTreeNode> warnViolations = new TreeSet<GraalFeature.CallTreeNode>(TruffleFeature::blocklistViolationComparator);
    private final Set<GraalFeature.CallTreeNode> neverPartOfCompilationViolations = new TreeSet<GraalFeature.CallTreeNode>(TruffleFeature::blocklistViolationComparator);
    Set<AnalysisMethod> runtimeCompiledMethods;

    public String getURL() {
        return "https://github.com/oracle/graal/blob/master/substratevm/src/com.oracle.svm.truffle/src/com/oracle/svm/truffle/TruffleFeature.java";
    }

    public String getDescription() {
        return "Enables compilation of Truffle ASTs to machine code";
    }

    @Override
    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(SubstrateThreadLocalHandshake.FOREIGN_POLL);
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        new SubstrateThreadLocalHandshakeSnippets(options, providers, lowerings);
    }

    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        if (providers.getLowerer().getTarget().arch instanceof AMD64) {
            AMD64TruffleInvocationPlugins.register((Architecture)providers.getLowerer().getTarget().arch, (InvocationPlugins)plugins.getInvocationPlugins(), (Replacements)providers.getReplacements());
        }
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(GraalFeature.class, TruffleBaseFeature.class);
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Truffle.getRuntime() instanceof SubstrateTruffleRuntime;
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        UserError.guarantee(Truffle.getRuntime() instanceof SubstrateTruffleRuntime, "TruffleFeature requires SubstrateTruffleRuntime", new Object[0]);
        ((SubstrateTruffleRuntime)Truffle.getRuntime()).resetHosted();
    }

    public void cleanup() {
        if (Truffle.getRuntime() instanceof SubstrateTruffleRuntime) {
            ((SubstrateTruffleRuntime)Truffle.getRuntime()).resetNativeImageState();
        }
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        access.getHostVM().registerNeverInlineTrivialHandler(this::neverInlineTrivial);
        if (!ImageSingletons.contains(TruffleSupport.class)) {
            ImageSingletons.add(TruffleSupport.class, (Object)new TruffleSupport());
        }
    }

    private void registerNeverPartOfCompilation(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, CompilerAsserts.class);
        r.setAllowOverwrite(true);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("neverPartOfCompilation", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                return TruffleFeature.this.handleNeverPartOfCompilation(b, targetMethod, null);
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("neverPartOfCompilation", new Type[]{String.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode message) {
                return TruffleFeature.this.handleNeverPartOfCompilation(b, targetMethod, message);
            }
        });
    }

    private boolean handleNeverPartOfCompilation(GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode messageNode) {
        String message = "CompilerAsserts.neverPartOfCompilation()";
        if (messageNode != null && messageNode.isConstant()) {
            message = messageNode.asConstant().toValueString();
        }
        NeverPartOfCompilationNode neverPartOfCompilation = (NeverPartOfCompilationNode)b.add((ValueNode)new NeverPartOfCompilationNode(message));
        if (Options.TruffleCheckNeverPartOfCompilation.getValue().booleanValue() && !neverPartOfCompilation.stateAfter().getMethod().getDeclaringClass().equals(targetMethod.getDeclaringClass())) {
            GraalFeature.CallTreeNode callerNode = ((GraalFeature.RuntimeBytecodeParser)b).getCallTreeNode();
            GraalFeature.CallTreeNode calleeNode = new GraalFeature.CallTreeNode(targetMethod, targetMethod, callerNode, callerNode.getLevel() + 1, GraalFeature.buildSourceReference(neverPartOfCompilation.stateAfter()));
            this.neverPartOfCompilationViolations.add(calleeNode);
        }
        return true;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        SubstrateTruffleRuntime truffleRuntime = (SubstrateTruffleRuntime)Truffle.getRuntime();
        FeatureImpl.BeforeAnalysisAccessImpl config = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        ((TruffleBaseFeature)ImageSingletons.lookup(TruffleBaseFeature.class)).setProfilingEnabled(truffleRuntime.isProfilingEnabled());
        for (Class initType : truffleRuntime.getLookupTypes()) {
            access.registerAsUsed(initType);
        }
        config.registerAsRoot((AnalysisMethod)SubstrateThreadLocalHandshake.FOREIGN_POLL.findMethod((MetaAccessProvider)config.getMetaAccess()), true);
        GraalFeature graalFeature = (GraalFeature)ImageSingletons.lookup(GraalFeature.class);
        SnippetReflectionProvider snippetReflection = graalFeature.getHostedProviders().getSnippetReflection();
        SubstrateTruffleCompiler truffleCompiler = truffleRuntime.initTruffleCompiler();
        truffleRuntime.initializeKnownMethods((MetaAccessProvider)config.getMetaAccess());
        truffleRuntime.initializeHostedKnownMethods(config.getUniverse().getOriginalMetaAccess());
        PartialEvaluator partialEvaluator = truffleCompiler.getPartialEvaluator();
        TruffleFeature.registerKnownTruffleFields(config, partialEvaluator.getKnownTruffleTypes());
        TruffleSupport.singleton().registerInterpreterEntryMethodsAsCompiled(partialEvaluator, access);
        GraphBuilderConfiguration graphBuilderConfig = partialEvaluator.getConfigPrototype();
        if (Options.TruffleInlineDuringParsing.getValue().booleanValue()) {
            graphBuilderConfig.getPlugins().appendInlineInvokePlugin((InlineInvokePlugin)new TruffleParsingInlineInvokePlugin(config.getHostVM(), graalFeature.getHostedProviders().getReplacements(), graphBuilderConfig.getPlugins().getInvocationPlugins(), partialEvaluator, method -> this.includeCallee((ResolvedJavaMethod)method, null, null)));
        }
        this.registerNeverPartOfCompilation(graphBuilderConfig.getPlugins().getInvocationPlugins());
        graphBuilderConfig.getPlugins().getInvocationPlugins().closeRegistration();
        Providers peProviders = partialEvaluator.getProviders();
        HostedProviders newHostedProviders = new HostedProviders(peProviders.getMetaAccess(), peProviders.getCodeCache(), peProviders.getConstantReflection(), (ConstantFieldProvider)new HostedTruffleConstantFieldProvider(peProviders.getConstantFieldProvider()), peProviders.getForeignCalls(), peProviders.getLowerer(), peProviders.getReplacements(), peProviders.getStampProvider(), snippetReflection, graalFeature.getHostedProviders().getWordTypes(), graalFeature.getHostedProviders().getPlatformConfigurationProvider(), graalFeature.getHostedProviders().getMetaAccessExtensionProvider(), graalFeature.getHostedProviders().getLoopsDataProvider());
        newHostedProviders.setGraphBuilderPlugins(graphBuilderConfig.getPlugins());
        graalFeature.initializeRuntimeCompilationConfiguration(newHostedProviders, graphBuilderConfig, this::includeCallee, this::deoptimizeOnException);
        for (ResolvedJavaMethod method2 : partialEvaluator.getCompilationRootMethods()) {
            graalFeature.prepareMethodForRuntimeCompilation(method2, config);
        }
        this.initializeMethodBlocklist((MetaAccessProvider)config.getMetaAccess(), (Feature.FeatureAccess)access);
        for (ResolvedJavaMethod method2 : truffleRuntime.getAnyFrameMethod()) {
            graalFeature.requireFrameInformationForMethod(method2);
            config.registerAsRoot((AnalysisMethod)method2, true);
        }
        access.registerAsInHeap(TruffleSupport.singleton().getOptimizedCallTargetClass());
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.PolyglotEngineImpl", "resetFallbackEngine", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.preInitializeEngine();
        ((FeatureImpl.BeforeAnalysisAccessImpl)access).ensureInitialized("org.graalvm.polyglot.io.IOHelper");
        config.registerSubtypeReachabilityHandler((acc, klass) -> {
            FeatureImpl.DuringAnalysisAccessImpl impl = (FeatureImpl.DuringAnalysisAccessImpl)acc;
            Boolean modified = (Boolean)TruffleBaseFeature.invokeStaticMethod("org.graalvm.compiler.truffle.runtime.BytecodeOSRRootNode", "initializeClassUsingDeprecatedFrameTransfer", Collections.singleton(Class.class), klass);
            if (modified != null && modified.booleanValue() && !impl.concurrentReachabilityHandlers()) {
                impl.requireAnalysisIteration();
            }
        }, BytecodeOSRNode.class);
    }

    private static void registerKnownTruffleFields(FeatureImpl.BeforeAnalysisAccessImpl config, KnownTruffleTypes knownTruffleFields) {
        for (Class<?> klass = knownTruffleFields.getClass(); klass != Object.class; klass = klass.getSuperclass()) {
            for (Field field : klass.getDeclaredFields()) {
                if (!Modifier.isPublic(field.getModifiers())) continue;
                try {
                    Object value = field.get(knownTruffleFields);
                    if (!(value instanceof ResolvedJavaField)) continue;
                    config.registerAsAccessed((AnalysisField)value);
                }
                catch (IllegalAccessException ex) {
                    throw VMError.shouldNotReachHere(ex);
                }
            }
        }
    }

    private boolean includeCallee(GraalFeature.CallTreeNode calleeNode, List<AnalysisMethod> implementationMethods) {
        return this.includeCallee((ResolvedJavaMethod)calleeNode.getImplementationMethod(), calleeNode, implementationMethods);
    }

    private boolean includeCallee(ResolvedJavaMethod implementationMethod, GraalFeature.CallTreeNode calleeNode, List<AnalysisMethod> implementationMethods) {
        if (implementationMethod.getAnnotation(CompilerDirectives.TruffleBoundary.class) != null) {
            return false;
        }
        if (!((SubstrateTruffleRuntime)Truffle.getRuntime()).isInlineable(implementationMethod)) {
            return false;
        }
        if (implementationMethod.getAnnotation(TruffleCallBoundary.class) != null) {
            return false;
        }
        if (calleeNode != null && implementationMethods.size() > 4 && this.isBlocklisted((ResolvedJavaMethod)calleeNode.getTargetMethod())) {
            this.blocklistViolations.add(new GraalFeature.CallTreeNode((ResolvedJavaMethod)calleeNode.getTargetMethod(), (ResolvedJavaMethod)calleeNode.getTargetMethod(), calleeNode.getParent(), calleeNode.getLevel(), calleeNode.getSourceReference()));
            return false;
        }
        if (this.isBlocklisted(implementationMethod)) {
            if (calleeNode != null) {
                this.blocklistViolations.add(calleeNode);
            }
            return false;
        }
        if (this.warnMethods.contains(implementationMethod) && calleeNode != null) {
            this.warnViolations.add(calleeNode);
        }
        return true;
    }

    boolean isBlocklisted(ResolvedJavaMethod method) {
        if (!((AnalysisMethod)method).allowRuntimeCompilation()) {
            return true;
        }
        return this.blocklistMethods.contains(method);
    }

    private boolean deoptimizeOnException(ResolvedJavaMethod method) {
        if (method == null) {
            return false;
        }
        CompilerDirectives.TruffleBoundary truffleBoundary = (CompilerDirectives.TruffleBoundary)method.getAnnotation(CompilerDirectives.TruffleBoundary.class);
        return truffleBoundary != null && truffleBoundary.transferToInterpreterOnException();
    }

    private void initializeMethodBlocklist(MetaAccessProvider metaAccess, Feature.FeatureAccess featureAccess) {
        this.blocklistMethod(metaAccess, Object.class, "equals", Object.class);
        this.blocklistMethod(metaAccess, Object.class, "hashCode", new Class[0]);
        this.blocklistMethod(metaAccess, Object.class, "toString", new Class[0]);
        this.blocklistMethod(metaAccess, String.class, "valueOf", Object.class);
        this.blocklistMethod(metaAccess, String.class, "getBytes", new Class[0]);
        this.blocklistMethod(metaAccess, String.class, "indexOf", Integer.TYPE);
        this.blocklistMethod(metaAccess, String.class, "indexOf", Integer.TYPE, Integer.TYPE);
        this.blocklistMethod(metaAccess, String.class, "indexOf", String.class);
        this.blocklistMethod(metaAccess, String.class, "indexOf", String.class, Integer.TYPE);
        this.blocklistMethod(metaAccess, Throwable.class, "fillInStackTrace", new Class[0]);
        this.blocklistMethod(metaAccess, Throwable.class, "initCause", Throwable.class);
        this.blocklistMethod(metaAccess, Throwable.class, "addSuppressed", Throwable.class);
        this.blocklistMethod(metaAccess, System.class, "getProperty", String.class);
        this.blocklistAllMethods(metaAccess, AssertionError.class);
        this.blocklistAllMethods(metaAccess, BigInteger.class);
        this.blocklistAllMethods(metaAccess, BigDecimal.class);
        this.blocklistAllMethods(metaAccess, Comparable.class);
        this.blocklistAllMethods(metaAccess, Comparator.class);
        this.blocklistAllMethods(metaAccess, Collection.class);
        this.blocklistAllMethods(metaAccess, List.class);
        this.blocklistAllMethods(metaAccess, Set.class);
        this.blocklistAllMethods(metaAccess, Map.class);
        this.blocklistAllMethods(metaAccess, Map.Entry.class);
        this.blocklistAllMethods(metaAccess, TreeMap.class);
        this.blocklistAllMethods(metaAccess, HashMap.class);
        this.blocklistAllMethods(metaAccess, ConcurrentHashMap.class);
        this.blocklistAllMethods(metaAccess, WeakHashMap.class);
        this.blocklistAllMethods(metaAccess, IdentityHashMap.class);
        this.blocklistAllMethods(metaAccess, Iterable.class);
        this.blocklistAllMethods(metaAccess, Iterator.class);
        this.blocklistAllMethods(metaAccess, ListIterator.class);
        this.blocklistAllMethods(metaAccess, ReentrantLock.class);
        this.allowlistMethod(metaAccess, BigInteger.class, "signum", new Class[0]);
        this.allowlistMethod(metaAccess, ReentrantLock.class, "isLocked", new Class[0]);
        this.allowlistMethod(metaAccess, ReentrantLock.class, "isHeldByCurrentThread", new Class[0]);
        this.allowlistMethod(metaAccess, ReentrantLock.class, "getOwner", new Class[0]);
        this.allowlistMethod(metaAccess, ReentrantLock.class, "<init>", new Class[0]);
        this.blocklistAllMethods(metaAccess, StringBuffer.class);
        this.blocklistAllMethods(metaAccess, Vector.class);
        this.blocklistAllMethods(metaAccess, Hashtable.class);
        this.blocklistAllMethods(metaAccess, BiConsumer.class);
        this.blocklistAllMethods(metaAccess, BiFunction.class);
        this.blocklistAllMethods(metaAccess, BinaryOperator.class);
        this.blocklistAllMethods(metaAccess, BiPredicate.class);
        this.blocklistAllMethods(metaAccess, BooleanSupplier.class);
        this.blocklistAllMethods(metaAccess, Consumer.class);
        this.blocklistAllMethods(metaAccess, DoubleBinaryOperator.class);
        this.blocklistAllMethods(metaAccess, DoubleConsumer.class);
        this.blocklistAllMethods(metaAccess, DoubleFunction.class);
        this.blocklistAllMethods(metaAccess, DoublePredicate.class);
        this.blocklistAllMethods(metaAccess, DoubleSupplier.class);
        this.blocklistAllMethods(metaAccess, DoubleToIntFunction.class);
        this.blocklistAllMethods(metaAccess, DoubleToLongFunction.class);
        this.blocklistAllMethods(metaAccess, DoubleUnaryOperator.class);
        this.blocklistAllMethods(metaAccess, Function.class);
        this.blocklistAllMethods(metaAccess, IntBinaryOperator.class);
        this.blocklistAllMethods(metaAccess, IntConsumer.class);
        this.blocklistAllMethods(metaAccess, IntFunction.class);
        this.blocklistAllMethods(metaAccess, IntPredicate.class);
        this.blocklistAllMethods(metaAccess, IntSupplier.class);
        this.blocklistAllMethods(metaAccess, IntToDoubleFunction.class);
        this.blocklistAllMethods(metaAccess, IntToLongFunction.class);
        this.blocklistAllMethods(metaAccess, IntUnaryOperator.class);
        this.blocklistAllMethods(metaAccess, LongBinaryOperator.class);
        this.blocklistAllMethods(metaAccess, LongConsumer.class);
        this.blocklistAllMethods(metaAccess, LongFunction.class);
        this.blocklistAllMethods(metaAccess, LongPredicate.class);
        this.blocklistAllMethods(metaAccess, LongSupplier.class);
        this.blocklistAllMethods(metaAccess, LongToDoubleFunction.class);
        this.blocklistAllMethods(metaAccess, LongToIntFunction.class);
        this.blocklistAllMethods(metaAccess, LongUnaryOperator.class);
        this.blocklistAllMethods(metaAccess, ObjDoubleConsumer.class);
        this.blocklistAllMethods(metaAccess, ObjIntConsumer.class);
        this.blocklistAllMethods(metaAccess, ObjLongConsumer.class);
        this.blocklistAllMethods(metaAccess, Predicate.class);
        this.blocklistAllMethods(metaAccess, Supplier.class);
        this.blocklistAllMethods(metaAccess, ToDoubleBiFunction.class);
        this.blocklistAllMethods(metaAccess, ToDoubleFunction.class);
        this.blocklistAllMethods(metaAccess, ToIntBiFunction.class);
        this.blocklistAllMethods(metaAccess, ToIntFunction.class);
        this.blocklistAllMethods(metaAccess, ToLongBiFunction.class);
        this.blocklistAllMethods(metaAccess, ToLongFunction.class);
        this.blocklistAllMethods(metaAccess, UnaryOperator.class);
        this.blocklistAllMethods(metaAccess, featureAccess.findClassByName("java.lang.StringConcatHelper"));
        this.warnAllMethods(metaAccess, JavaStackWalker.class);
        this.warnAllMethods(metaAccess, Deoptimizer.class);
        this.warnAllMethods(metaAccess, Heap.getHeap().getClass());
    }

    private void blocklistAllMethods(MetaAccessProvider metaAccess, Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            this.blocklistMethods.add(metaAccess.lookupJavaMethod((Executable)method));
        }
        for (Executable executable : clazz.getDeclaredConstructors()) {
            this.blocklistMethods.add(metaAccess.lookupJavaMethod(executable));
        }
    }

    private void blocklistMethod(MetaAccessProvider metaAccess, Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            this.blocklistMethods.add(metaAccess.lookupJavaMethod((Executable)clazz.getDeclaredMethod(name, parameterTypes)));
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private void allowlistMethod(MetaAccessProvider metaAccess, Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            Executable method = "<init>".equals(name) ? clazz.getDeclaredConstructor(parameterTypes) : clazz.getDeclaredMethod(name, parameterTypes);
            if (!this.blocklistMethods.remove(metaAccess.lookupJavaMethod(method))) {
                throw VMError.shouldNotReachHere();
            }
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private void warnAllMethods(MetaAccessProvider metaAccess, Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (GuardedAnnotationAccess.getAnnotationTypes((AnnotatedElement)method).length != 0 || ((Executable)method).getName().startsWith("get") || ((Executable)method).getName().startsWith("set")) continue;
            this.warnMethods.add(metaAccess.lookupJavaMethod((Executable)method));
        }
        for (Executable executable : clazz.getDeclaredConstructors()) {
            if (GuardedAnnotationAccess.getAnnotationTypes((AnnotatedElement)executable).length != 0) continue;
            this.warnMethods.add(metaAccess.lookupJavaMethod(executable));
        }
    }

    private static int blocklistViolationComparator(GraalFeature.CallTreeNode n1, GraalFeature.CallTreeNode n2) {
        int result = n1.getTargetMethod().getQualifiedName().compareTo(n2.getTargetMethod().getQualifiedName());
        if (result == 0) {
            result = n1.getSourceReference().compareTo(n2.getSourceReference());
        }
        return result;
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess config) {
        Optional<HostedType> optionalFrameType;
        Object cur;
        boolean printBlockListViolations;
        FeatureImpl.BeforeCompilationAccessImpl access = (FeatureImpl.BeforeCompilationAccessImpl)config;
        boolean failBlockListViolations = Options.TruffleCheckBlockListMethods.getValue() != false || Options.TruffleCheckBlackListedMethods.getValue() != false;
        boolean bl = printBlockListViolations = GraalFeature.Options.PrintRuntimeCompileMethods.getValue() != false || failBlockListViolations;
        if (printBlockListViolations && this.blocklistViolations.size() > 0) {
            System.out.println();
            System.out.println("=== Found " + this.blocklistViolations.size() + " compilation blocklist violations ===");
            System.out.println();
            for (GraalFeature.CallTreeNode node : this.blocklistViolations) {
                System.out.println("Blocklisted method");
                System.out.println(node.getImplementationMethod().format("  %H.%n(%p)"));
                System.out.println("called from");
                for (cur = node; cur != null; cur = ((GraalFeature.CallTreeNode)cur).getParent()) {
                    System.out.println("  " + ((GraalFeature.CallTreeNode)cur).getSourceReference());
                }
            }
            if (failBlockListViolations) {
                throw VMError.shouldNotReachHere("Blocklisted methods are reachable for runtime compilation");
            }
        }
        if (this.warnViolations.size() > 0) {
            Object printNode = null;
            int printLength = Integer.MAX_VALUE;
            cur = this.warnViolations.iterator();
            while (cur.hasNext()) {
                GraalFeature.CallTreeNode warnNode = cur.next();
                int warnLength = 0;
                for (GraalFeature.CallTreeNode cur2 = warnNode; cur2 != null; cur2 = cur2.getParent()) {
                    ++warnLength;
                }
                if (warnLength >= printLength) continue;
                printNode = warnNode;
                printLength = warnLength;
            }
            System.out.println("Warning: suspicious method reachable for runtime compilation: " + ((GraalFeature.CallTreeNode)printNode).getImplementationMethod().format("%H.%n(%p)"));
            System.out.println("Check the complete tree of reachable methods using the option " + GraalFeature.Options.PrintRuntimeCompileMethods.getDescriptor().getFieldName());
            System.out.println("Suspicious method is called from");
            for (cur = printNode; cur != null; cur = ((GraalFeature.CallTreeNode)cur).getParent()) {
                System.out.println("  " + ((GraalFeature.CallTreeNode)cur).getSourceReference());
            }
        }
        if (this.neverPartOfCompilationViolations.size() > 0) {
            System.out.println("Error: CompilerAsserts.neverPartOfCompilation reachable for runtime compilation from " + this.neverPartOfCompilationViolations.size() + " places:");
            for (GraalFeature.CallTreeNode neverPartOfCompilationNode : this.neverPartOfCompilationViolations) {
                System.out.println("called from");
                for (cur = neverPartOfCompilationNode; cur != null; cur = ((GraalFeature.CallTreeNode)cur).getParent()) {
                    System.out.println("  " + ((GraalFeature.CallTreeNode)cur).getSourceReference());
                }
            }
            throw VMError.shouldNotReachHere("CompilerAsserts.neverPartOfCompilation reachable for runtime compilation");
        }
        if (Options.TruffleCheckFrameImplementation.getValue().booleanValue() && (optionalFrameType = access.getMetaAccess().optionalLookupJavaType(Frame.class)).isPresent()) {
            HostedType frameType = optionalFrameType.get();
            HashSet<HostedType> implementations = new HashSet<HostedType>();
            TruffleFeature.collectImplementations(frameType, implementations);
            if (implementations.size() > 1) {
                throw UserError.abort("More than one implementation of %s found. For performance reasons, Truffle languages must not provide new implementations, and instead only use the single implementation provided by the Truffle runtime. To disable this check, add %s to the native-image command line. Found classes: %s", Frame.class.getTypeName(), SubstrateOptionsParser.commandArgument(Options.TruffleCheckFrameImplementation, "-"), implementations.stream().map(m -> m.toJavaName(true)).collect(Collectors.joining(", ")));
            }
            assert (implementations.size() == 0 || implementations.iterator().next() == frameType.getSingleImplementor());
        }
    }

    private boolean neverInlineTrivial(AnalysisMethod caller, AnalysisMethod callee) {
        if (this.runtimeCompiledMethods != null && !this.runtimeCompiledMethods.contains(caller)) {
            return false;
        }
        return TruffleHostInliningPhase.shouldDenyTrivialInlining((ResolvedJavaMethod)callee);
    }

    private static void collectImplementations(HostedType type, Set<HostedType> implementations) {
        for (HostedType subType : type.getSubTypes()) {
            if (!subType.isAbstract()) {
                implementations.add(subType);
            }
            TruffleFeature.collectImplementations(subType, implementations);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        if (Options.PrintStaticTruffleBoundaries.getValue().booleanValue()) {
            TruffleFeature.printStaticTruffleBoundaries();
        }
        SubstrateTruffleRuntime truffleRuntime = (SubstrateTruffleRuntime)Truffle.getRuntime();
        FeatureImpl.AfterAnalysisAccessImpl config = (FeatureImpl.AfterAnalysisAccessImpl)access;
        truffleRuntime.initializeHostedKnownMethods((MetaAccessProvider)config.getMetaAccess());
        this.runtimeCompiledMethods = new LinkedHashSet<AnalysisMethod>();
        this.runtimeCompiledMethods.addAll(Arrays.asList(config.getMetaAccess().lookupJavaType(CompilerDirectives.class).getDeclaredMethods()));
        this.runtimeCompiledMethods.addAll(Arrays.asList(config.getMetaAccess().lookupJavaType(CompilerAsserts.class).getDeclaredMethods()));
        for (GraalFeature.CallTreeNode runtimeCompiledMethod : ((GraalFeature)ImageSingletons.lookup(GraalFeature.class)).getRuntimeCompiledMethods().values()) {
            this.runtimeCompiledMethods.add(runtimeCompiledMethod.getImplementationMethod());
            StructuredGraph graph = runtimeCompiledMethod.getGraph();
            if (graph == null) continue;
            for (ResolvedJavaMethod method : graph.getMethods()) {
                if (!(method instanceof AnalysisMethod)) {
                    throw VMError.shouldNotReachHere("method should be an analysis method");
                }
                if (method.getAnnotation(CompilerDirectives.TruffleBoundary.class) != null) {
                    throw VMError.shouldNotReachHere("method used during runtime compilation must never be annotated with a truffle boundary");
                }
                this.runtimeCompiledMethods.add((AnalysisMethod)method);
            }
        }
    }

    private static void printStaticTruffleBoundaries() {
        HashSet<ResolvedJavaMethod> foundBoundaries = new HashSet<ResolvedJavaMethod>();
        int callSiteCount = 0;
        int calleeCount = 0;
        for (GraalFeature.CallTreeNode node : ((GraalFeature)ImageSingletons.lookup(GraalFeature.class)).getRuntimeCompiledMethods().values()) {
            StructuredGraph graph = node.getGraph();
            for (MethodCallTargetNode callTarget : graph.getNodes(MethodCallTargetNode.TYPE)) {
                ResolvedJavaMethod targetMethod = callTarget.targetMethod();
                CompilerDirectives.TruffleBoundary truffleBoundary = (CompilerDirectives.TruffleBoundary)targetMethod.getAnnotation(CompilerDirectives.TruffleBoundary.class);
                if (truffleBoundary == null) continue;
                ++callSiteCount;
                if (foundBoundaries.contains(targetMethod)) continue;
                foundBoundaries.add(targetMethod);
                System.out.println("Truffle boundary found: " + targetMethod);
                ++calleeCount;
            }
        }
        System.out.printf("Number of Truffle call boundaries: %d, number of unique called methods outside the boundary: %d%n", callSiteCount, calleeCount);
    }

    @Override
    public void registerGraalPhases(Providers providers, SnippetReflectionProvider snippetReflection, Suites suites, boolean hosted) {
        if (hosted && ((Boolean)TruffleHostInliningPhase.Options.TruffleHostInlining.getValue(HostedOptionValues.singleton())).booleanValue() && suites.getHighTier() instanceof HighTier) {
            suites.getHighTier().prependPhase((BasePhase)new SubstrateTruffleHostInliningPhase(CanonicalizerPhase.create()));
        }
    }

    static class TruffleParsingInlineInvokePlugin
    implements InlineInvokePlugin {
        private final SVMHost hostVM;
        private final Replacements replacements;
        private final InvocationPlugins invocationPlugins;
        private final PartialEvaluator partialEvaluator;
        private final Predicate<ResolvedJavaMethod> includeMethodPredicate;

        TruffleParsingInlineInvokePlugin(SVMHost hostVM, Replacements replacements, InvocationPlugins invocationPlugins, PartialEvaluator partialEvaluator, Predicate<ResolvedJavaMethod> includeMethodPredicate) {
            this.hostVM = hostVM;
            this.replacements = replacements;
            this.invocationPlugins = invocationPlugins;
            this.partialEvaluator = partialEvaluator;
            this.includeMethodPredicate = includeMethodPredicate;
        }

        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext builder, ResolvedJavaMethod original, ValueNode[] arguments) {
            if (original.hasNeverInlineDirective()) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (this.invocationPlugins.lookupInvocation(original, builder.getOptions()) != null) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (original.getAnnotation(ExplodeLoop.class) != null) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (builder.getMethod().getAnnotation(ExplodeLoop.class) != null) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (this.replacements.hasSubstitution(original, builder.getOptions())) {
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            for (ResolvedJavaMethod m : this.partialEvaluator.getNeverInlineMethods()) {
                if (!original.equals(m)) continue;
                return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (original.getCode() != null && this.includeMethodPredicate.test(original) && this.hostVM.isAnalysisTrivialMethod((AnalysisMethod)original) && builder.getDepth() < (Integer)BytecodeParserOptions.InlineDuringParsingMaxDepth.getValue(HostedOptionValues.singleton())) {
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)original);
            }
            return null;
        }
    }

    public static final class IsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(TruffleFeature.class);
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> PrintStaticTruffleBoundaries = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> TruffleCheckNeverPartOfCompilation = new HostedOptionKey<Boolean>(true);
        public static final HostedOptionKey<Boolean> TruffleCheckFrameImplementation = new HostedOptionKey<Boolean>(true);
        public static final HostedOptionKey<Boolean> TruffleCheckBlackListedMethods = new HostedOptionKey<Boolean>(true);
        public static final HostedOptionKey<Boolean> TruffleCheckBlockListMethods = new HostedOptionKey<Boolean>(true);
        public static final HostedOptionKey<Boolean> TruffleInlineDuringParsing = new HostedOptionKey<Boolean>(true);
    }
}

