/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.thread;

import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.nodes.ReadReservedRegister;
import com.oracle.svm.core.graal.thread.AddressOfVMThreadLocalNode;
import com.oracle.svm.core.graal.thread.CompareAndSetVMThreadLocalNode;
import com.oracle.svm.core.graal.thread.LoadVMThreadLocalNode;
import com.oracle.svm.core.graal.thread.StoreVMThreadLocalNode;
import com.oracle.svm.core.heap.InstanceReferenceMapEncoder;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import com.oracle.svm.core.threadlocal.FastThreadLocal;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfos;
import com.oracle.svm.core.threadlocal.VMThreadLocalMTSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.thread.VMThreadLocalCollector;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class VMThreadMTFeature
implements InternalFeature {
    private final VMThreadLocalCollector threadLocalCollector = new VMThreadLocalCollector();
    private final VMThreadLocalMTSupport threadLocalSupport = new VMThreadLocalMTSupport();

    public int getVMThreadSize() {
        assert (this.threadLocalSupport.vmThreadSize != -1) : "not yet initialized";
        return this.threadLocalSupport.vmThreadSize;
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.MultiThreaded.getValue();
    }

    public void duringSetup(Feature.DuringSetupAccess config) {
        ImageSingletons.add(VMThreadLocalMTSupport.class, (Object)this.threadLocalSupport);
        config.registerObjectReplacer((Function)this.threadLocalCollector);
    }

    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        Class[] typesWithGetAddress;
        for (Class<? extends FastThreadLocal> threadLocalClass : VMThreadLocalInfo.THREAD_LOCAL_CLASSES) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), threadLocalClass);
            Class<?> valueClass = VMThreadLocalInfo.getValueClass(threadLocalClass);
            this.registerAccessors(r, valueClass, false);
            this.registerAccessors(r, valueClass, true);
            r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("compareAndSet", new Type[]{InvocationPlugin.Receiver.class, valueClass, valueClass}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode expect, ValueNode update) {
                    ValueNode threadNode = VMThreadMTFeature.currentThread(b);
                    return VMThreadMTFeature.this.handleCompareAndSet(b, targetMethod, receiver, threadNode, expect, update);
                }
            });
            r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("compareAndSet", new Type[]{InvocationPlugin.Receiver.class, IsolateThread.class, valueClass, valueClass}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode, ValueNode expect, ValueNode update) {
                    return VMThreadMTFeature.this.handleCompareAndSet(b, targetMethod, receiver, threadNode, expect, update);
                }
            });
        }
        for (Class type : typesWithGetAddress = new Class[]{FastThreadLocalBytes.class, FastThreadLocalWord.class}) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), (Type)type);
            r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("getAddress", new Type[]{InvocationPlugin.Receiver.class}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    ValueNode threadNode = VMThreadMTFeature.currentThread(b);
                    return VMThreadMTFeature.this.handleGetAddress(b, targetMethod, receiver, threadNode);
                }
            });
            r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("getAddress", new Type[]{InvocationPlugin.Receiver.class, IsolateThread.class}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode) {
                    return VMThreadMTFeature.this.handleGetAddress(b, targetMethod, receiver, threadNode);
                }
            });
        }
    }

    private void registerAccessors(InvocationPlugins.Registration r, Class<?> valueClass, final boolean isVolatile) {
        String suffix = isVolatile ? "Volatile" : "";
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get" + suffix, new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode threadNode = VMThreadMTFeature.currentThread(b);
                return VMThreadMTFeature.this.handleGet(b, targetMethod, receiver, threadNode, isVolatile);
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get" + suffix, new Type[]{InvocationPlugin.Receiver.class, IsolateThread.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode) {
                return VMThreadMTFeature.this.handleGet(b, targetMethod, receiver, threadNode, isVolatile);
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("set" + suffix, new Type[]{InvocationPlugin.Receiver.class, valueClass}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode valueNode) {
                ValueNode threadNode = VMThreadMTFeature.currentThread(b);
                return VMThreadMTFeature.this.handleSet(b, receiver, threadNode, valueNode, isVolatile);
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("set" + suffix, new Type[]{InvocationPlugin.Receiver.class, IsolateThread.class, valueClass}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode, ValueNode valueNode) {
                return VMThreadMTFeature.this.handleSet(b, receiver, threadNode, valueNode, isVolatile);
            }
        });
    }

    private static ValueNode currentThread(GraphBuilderContext b) {
        return b.add(ReadReservedRegister.createReadIsolateThreadNode(b.getGraph()));
    }

    private boolean handleGet(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode, boolean isVolatile) {
        VMThreadLocalInfo threadLocalInfo = this.threadLocalCollector.findInfo(b, receiver.get());
        LoadVMThreadLocalNode node = new LoadVMThreadLocalNode(b.getMetaAccess(), threadLocalInfo, threadNode, OnHeapMemoryAccess.BarrierType.NONE, isVolatile ? MemoryOrderMode.VOLATILE : MemoryOrderMode.PLAIN);
        b.addPush(targetMethod.getSignature().getReturnKind(), (ValueNode)node);
        return true;
    }

    private boolean handleSet(GraphBuilderContext b, InvocationPlugin.Receiver receiver, ValueNode threadNode, ValueNode valueNode, boolean isVolatile) {
        VMThreadLocalInfo threadLocalInfo = this.threadLocalCollector.findInfo(b, receiver.get());
        StoreVMThreadLocalNode store = (StoreVMThreadLocalNode)b.add((ValueNode)new StoreVMThreadLocalNode(threadLocalInfo, threadNode, valueNode, OnHeapMemoryAccess.BarrierType.NONE, isVolatile ? MemoryOrderMode.VOLATILE : MemoryOrderMode.PLAIN));
        assert (store.stateAfter() != null) : store + " has no state after with graph builder context " + b;
        return true;
    }

    private boolean handleCompareAndSet(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode, ValueNode expect, ValueNode update) {
        VMThreadLocalInfo threadLocalInfo = this.threadLocalCollector.findInfo(b, receiver.get());
        CompareAndSetVMThreadLocalNode cas = new CompareAndSetVMThreadLocalNode(threadLocalInfo, threadNode, expect, update);
        b.addPush(targetMethod.getSignature().getReturnKind(), (ValueNode)cas);
        assert (cas.stateAfter() != null) : cas + " has no state after with graph builder context " + b;
        return true;
    }

    private boolean handleGetAddress(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode threadNode) {
        VMThreadLocalInfo threadLocalInfo = this.threadLocalCollector.findInfo(b, receiver.get());
        b.addPush(targetMethod.getSignature().getReturnKind(), (ValueNode)new AddressOfVMThreadLocalNode(threadLocalInfo, threadNode));
        return true;
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        if (VMThreadLocalInfos.setInfos(this.threadLocalCollector.threadLocals.values())) {
            FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
            access.requireAnalysisIteration();
            access.rescanField(ImageSingletons.lookup(VMThreadLocalInfos.class), VMThreadLocalCollector.threadLocalInfosField);
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess config) {
        List<VMThreadLocalInfo> sortedThreadLocalInfos = this.threadLocalCollector.sortThreadLocals();
        SubstrateReferenceMap referenceMap = new SubstrateReferenceMap();
        int nextOffset = 0;
        for (VMThreadLocalInfo info : sortedThreadLocalInfos) {
            int alignment = Math.min(8, info.sizeInBytes);
            nextOffset = NumUtil.roundUp((int)nextOffset, (int)alignment);
            if (info.isObject) {
                referenceMap.markReferenceAtOffset(nextOffset, true);
            }
            info.offset = nextOffset;
            nextOffset += info.sizeInBytes;
            if (info.offset <= info.maxOffset) continue;
            VMError.shouldNotReachHere("Too many thread local variables with maximum offset " + info.maxOffset + " defined");
        }
        InstanceReferenceMapEncoder encoder = new InstanceReferenceMapEncoder();
        encoder.add(referenceMap);
        NonmovableArray<Byte> referenceMapEncoding = encoder.encodeAll();
        this.threadLocalSupport.vmThreadReferenceMapEncoding = (byte[])NonmovableArrays.getHostedArray(referenceMapEncoding);
        this.threadLocalSupport.vmThreadReferenceMapIndex = encoder.lookupEncoding(referenceMap);
        this.threadLocalSupport.vmThreadSize = nextOffset;
        VMThreadLocalInfos.setInfos(sortedThreadLocalInfos);
    }

    public int offsetOf(FastThreadLocal threadLocal) {
        return this.threadLocalCollector.getInfo((FastThreadLocal)threadLocal).offset;
    }
}

