/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.results.StaticAnalysisResults;
import com.oracle.svm.core.c.BoxedRelocatedPointer;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.graal.code.SubstrateCompilationIdentifier;
import com.oracle.svm.core.graal.replacements.SubstrateGraphKit;
import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.phases.AnalysisGraphBuilderPhase;
import com.oracle.svm.hosted.phases.HostedGraphBuilderPhase;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.util.Providers;

public class HostedGraphKit
extends SubstrateGraphKit {
    public HostedGraphKit(DebugContext debug, HostedProviders providers, ResolvedJavaMethod method) {
        this(debug, providers, method, false);
    }

    public HostedGraphKit(DebugContext debug, HostedProviders providers, ResolvedJavaMethod method, boolean forceTrackNodeSourcePosition) {
        super(debug, method, (Providers)providers, providers.getWordTypes(), providers.getGraphBuilderPlugins(), new SubstrateCompilationIdentifier(), forceTrackNodeSourcePosition);
    }

    @Override
    protected MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, StampPair returnStamp, int bci) {
        ResolvedJavaMethod method = this.graph.method();
        if (method instanceof HostedMethod) {
            StaticAnalysisResults profilingInfo = ((HostedMethod)method).getProfilingInfo();
            return new SubstrateMethodCallTargetNode(invokeKind, targetMethod, args, returnStamp, profilingInfo.getTypeProfile(bci), profilingInfo.getMethodProfile(bci), profilingInfo.getStaticTypeProfile(bci));
        }
        return super.createMethodCallTarget(invokeKind, targetMethod, args, returnStamp, bci);
    }

    protected GraphBuilderPhase.Instance createGraphBuilderInstance(GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
        ResolvedJavaMethod method = this.graph.method();
        if (method instanceof AnalysisMethod) {
            return new AnalysisGraphBuilderPhase(this.getProviders(), graphBuilderConfig, optimisticOpts, initialIntrinsicContext, this.wordTypes);
        }
        if (method instanceof HostedMethod) {
            return new HostedGraphBuilderPhase(this.getProviders(), graphBuilderConfig, optimisticOpts, initialIntrinsicContext, this.wordTypes);
        }
        throw VMError.shouldNotReachHere();
    }

    public void emitEnsureInitializedCall(ResolvedJavaType type) {
        if (EnsureClassInitializedNode.needsRuntimeInitialization(this.graph.method().getDeclaringClass(), type)) {
            ConstantNode hub = this.createConstant((Constant)this.getConstantReflection().asJavaClass(type), JavaKind.Object);
            this.appendWithUnwind(new EnsureClassInitializedNode((ValueNode)hub));
        }
    }

    public <T extends WithExceptionNode> T appendWithUnwind(T withExceptionNode) {
        return this.appendWithUnwind(withExceptionNode, this.bci());
    }

    public LoadFieldNode createLoadFieldNode(ConstantNode receiver, Class<BoxedRelocatedPointer> clazz, String fieldName) {
        try {
            ResolvedJavaType type = this.getMetaAccess().lookupJavaType(clazz);
            if (type instanceof AnalysisType) {
                ((AnalysisType)type).registerAsReachable();
            }
            ResolvedJavaField field = this.getMetaAccess().lookupJavaField(clazz.getDeclaredField(fieldName));
            return LoadFieldNode.createOverrideStamp((StampPair)StampPair.createSingle((Stamp)this.wordStamp((ResolvedJavaType)field.getType())), (ValueNode)receiver, (ResolvedJavaField)field);
        }
        catch (NoSuchFieldException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public GuardingNode createCheckThrowingBytecodeException(LogicNode condition, boolean failOnTrue, BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, ValueNode ... arguments) {
        ProfileData.BranchProbabilityData trueProbability = failOnTrue ? BranchProbabilityNode.SLOW_PATH_PROFILE : BranchProbabilityNode.FAST_PATH_PROFILE;
        IfNode ifNode = this.startIf(condition, trueProbability);
        if (failOnTrue) {
            this.thenPart();
        } else {
            this.elsePart();
        }
        BytecodeExceptionNode exception = this.createBytecodeExceptionObjectNode(exceptionKind, true, arguments);
        this.append((ValueNode)new UnwindNode((ValueNode)exception));
        AbstractMergeNode merge = this.endIf();
        assert (merge == null);
        return failOnTrue ? ifNode.falseSuccessor() : ifNode.trueSuccessor();
    }

    public BytecodeExceptionNode createBytecodeExceptionObjectNode(BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, boolean rethrow, ValueNode ... arguments) {
        BytecodeExceptionNode exception = (BytecodeExceptionNode)this.append((ValueNode)new BytecodeExceptionNode(this.getMetaAccess(), exceptionKind, arguments));
        this.setStateAfterException(this.getFrameState(), this.bci(), (StateSplit)exception, rethrow);
        return exception;
    }

    public ValueNode maybeCreateExplicitNullCheck(ValueNode object) {
        assert (object.stamp(NodeView.DEFAULT).isPointerStamp());
        if (StampTool.isPointerNonNull((ValueNode)object)) {
            return object;
        }
        this.createCheckThrowingBytecodeException(IsNullNode.create((ValueNode)object), true, BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, new ValueNode[0]);
        return this.append(PiNode.create((ValueNode)object, (Stamp)StampFactory.objectNonNull()));
    }
}

