/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jni;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.jni.JNIGraphKit;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.thread.VMThreadMTFeature;
import java.util.ArrayList;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.nativeimage.ImageSingletons;

public class JNICallTrampolineMethod
extends CustomSubstitutionMethod {
    private final ResolvedJavaField jumpAddressField;
    private final boolean nonVirtual;

    public JNICallTrampolineMethod(ResolvedJavaMethod original, ResolvedJavaField jumpAddressField, boolean nonVirtual) {
        super(original);
        this.jumpAddressField = jumpAddressField;
        this.nonVirtual = nonVirtual;
    }

    @Override
    public int getModifiers() {
        return super.getModifiers() & 0xFFFFFEFF;
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        JNIGraphKit kit = new JNIGraphKit(debug, providers, method);
        kit.append((ValueNode)new LoweredDeadEndNode());
        return kit.finalizeGraph();
    }

    public CompileQueue.ParseFunction createCustomParseFunction() {
        return (debug, method, reason, config) -> {};
    }

    public CompileQueue.CompileFunction createCustomCompileFunction() {
        return (debug, method, identifier, reason, config) -> {
            SubstrateBackend backend = config.getBackendForNormalMethod();
            HostedProviders providers = (HostedProviders)config.getProviders();
            ArrayList<ResolvedJavaType> parameters = new ArrayList<ResolvedJavaType>();
            parameters.add(providers.getMetaAccess().lookupJavaType(JNIEnvironment.class));
            parameters.add(providers.getMetaAccess().lookupJavaType(JNIObjectHandle.class));
            if (this.nonVirtual) {
                parameters.add(providers.getMetaAccess().lookupJavaType(JNIObjectHandle.class));
            }
            parameters.add(providers.getMetaAccess().lookupJavaType(JNIMethodId.class));
            ResolvedJavaType returnType = providers.getWordTypes().getWordImplType();
            CallingConvention callingConvention = backend.getCodeCache().getRegisterConfig().getCallingConvention((CallingConvention.Type)SubstrateCallingConventionKind.Native.toType(true), (JavaType)returnType, parameters.toArray(new JavaType[0]), (ValueKindFactory)backend);
            RegisterValue threadArg = null;
            int threadIsolateOffset = -1;
            if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                threadArg = (RegisterValue)callingConvention.getArgument(0);
                if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                    threadIsolateOffset = ((VMThreadMTFeature)ImageSingletons.lookup(VMThreadMTFeature.class)).offsetOf(VMThreads.IsolateTL);
                }
            }
            RegisterValue methodIdArg = (RegisterValue)callingConvention.getArgument(parameters.size() - 1);
            return backend.createJNITrampolineMethod(method, identifier, threadArg, threadIsolateOffset, methodIdArg, this.getFieldOffset(providers));
        };
    }

    private int getFieldOffset(HostedProviders providers) {
        HostedMetaAccess metaAccess = (HostedMetaAccess)providers.getMetaAccess();
        HostedUniverse universe = metaAccess.getUniverse();
        AnalysisUniverse analysisUniverse = universe.getBigBang().getUniverse();
        HostedField hostedField = universe.lookup((JavaField)analysisUniverse.lookup((JavaField)this.jumpAddressField));
        assert (hostedField.hasLocation());
        return hostedField.getLocation();
    }
}

