/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeJNIAccess;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.nativeimage.impl.RuntimeResourceSupport;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@AutomaticallyRegisteredFeature
public class JNIRegistrationAwt
extends JNIRegistrationUtil
implements InternalFeature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (Platform.includedIn(Platform.LINUX.class)) {
            access.registerReachabilityHandler(JNIRegistrationAwt::handlePreferencesClassReachable, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.Toolkit"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.cmm.lcms.LCMS"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.event.NativeLibLoader"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.NativeLibLoader"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.NativeLibLoader"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.image.ColorModel"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.X11GraphicsEnvironment"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.FontManagerNativeLibrary"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.print.CUPSPrinter"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.Disposer")});
            PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("java_awt");
            PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("sun_awt");
            PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("sun_java2d");
            PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("sun_print");
            access.registerReachabilityHandler(JNIRegistrationAwt::registerFreeType, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.FontManagerNativeLibrary")});
            PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("sun_font");
            access.registerReachabilityHandler(JNIRegistrationAwt::registerLCMS, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.java2d.cmm.lcms.LCMS")});
            access.registerReachabilityHandler(JNIRegistrationAwt::registerImagingLib, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.ImagingLib")});
            access.registerReachabilityHandler(JNIRegistrationAwt::registerJPEG, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.awt.image.JPEGImageDecoder"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageReader"), JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "com.sun.imageio.plugins.jpeg.JPEGImageWriter")});
            PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("com_sun_imageio_plugins_jpeg");
            access.registerReachabilityHandler(JNIRegistrationAwt::registerColorProfiles, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.color.ICC_Profile")});
            access.registerReachabilityHandler(JNIRegistrationAwt::registerFlavorMapProps, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "java.awt.datatransfer.SystemFlavorMap")});
            access.registerReachabilityHandler(JNIRegistrationAwt::registerRTFReaderCharsets, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.swing.text.rtf.RTFReader")});
            access.registerReachabilityHandler(JNIRegistrationAwt::registerOceanThemeIcons, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.swing.plaf.metal.OceanTheme")});
        }
    }

    private static void handlePreferencesClassReachable(Feature.DuringAnalysisAccess access) {
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.lang.System", "setProperty", String.class, String.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.lang.System", "loadLibrary", String.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{GraphicsEnvironment.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.method((Feature.FeatureAccess)access, "java.awt.GraphicsEnvironment", "isHeadless", new Class[0])});
        NativeLibraries nativeLibraries = JNIRegistrationAwt.getNativeLibraries(access);
        NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("awt");
        nativeLibraries.addStaticJniLibrary("awt", new String[0]);
        if (JNIRegistrationAwt.isHeadless()) {
            NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("awt_headless");
            nativeLibraries.addStaticJniLibrary("awt_headless", "awt");
        } else {
            NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("awt_xawt");
            nativeLibraries.addStaticJniLibrary("awt_xawt", "awt");
            nativeLibraries.addDynamicNonJniLibrary("X11");
            nativeLibraries.addDynamicNonJniLibrary("Xrender");
            nativeLibraries.addDynamicNonJniLibrary("Xext");
            nativeLibraries.addDynamicNonJniLibrary("Xi");
        }
        nativeLibraries.addDynamicNonJniLibrary("stdc++");
        nativeLibraries.addDynamicNonJniLibrary("m");
        access.registerReachabilityHandler(JNIRegistrationAwt::registerHtml32bdtd, new Object[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "javax.swing.text.html.HTMLEditorKit")});
    }

    private static void registerJPEG(Feature.DuringAnalysisAccess access) {
        NativeLibraries nativeLibraries = JNIRegistrationAwt.getNativeLibraries(access);
        NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("javajpeg");
        nativeLibraries.addStaticJniLibrary("javajpeg", new String[0]);
    }

    private static void registerImagingLib(Feature.DuringAnalysisAccess access) {
        NativeLibraries nativeLibraries = JNIRegistrationAwt.getNativeLibraries(access);
        NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("mlib_image");
        nativeLibraries.addStaticJniLibrary("mlib_image", new String[0]);
    }

    private static void registerLCMS(Feature.DuringAnalysisAccess access) {
        NativeLibraries nativeLibraries = JNIRegistrationAwt.getNativeLibraries(access);
        NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("lcms");
        nativeLibraries.addStaticJniLibrary("lcms", new String[0]);
    }

    private static void registerFreeType(Feature.DuringAnalysisAccess access) {
        if (SubstrateOptions.StaticExecutable.getValue().booleanValue()) {
            return;
        }
        NativeLibraries nativeLibraries = JNIRegistrationAwt.getNativeLibraries(access);
        NativeLibrarySupport.singleton().preregisterUninitializedBuiltinLibrary("fontmanager");
        nativeLibraries.addStaticJniLibrary("fontmanager", JNIRegistrationAwt.isHeadless() ? "awt_headless" : "awt_xawt");
        nativeLibraries.addDynamicNonJniLibrary("freetype");
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.FontConfigManager$FontConfigInfo")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.font.FontConfigManager$FontConfigInfo", "fcVersion", "cacheDirs"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.FontConfigManager$FcCompFont")});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.font.FontConfigManager$FcCompFont", "fcName", "firstFont", "allFonts"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationAwt.clazz((Feature.FeatureAccess)access, "sun.font.FontConfigManager$FontConfigFont")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationAwt.constructor((Feature.FeatureAccess)access, "sun.font.FontConfigManager$FontConfigFont", new Class[0])});
        RuntimeJNIAccess.register((Field[])JNIRegistrationAwt.fields((Feature.FeatureAccess)access, "sun.font.FontConfigManager$FontConfigFont", "familyName", "styleStr", "fullName", "fontFile"));
    }

    private static void registerColorProfiles(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), "sun.java2d.cmm.profiles.*");
    }

    private static void registerFlavorMapProps(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), "sun.datatransfer.resources.flavormap.properties");
    }

    private static void registerRTFReaderCharsets(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), "javax.swing.text.rtf.charsets.*");
    }

    private static void registerOceanThemeIcons(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), "javax.swing.plaf.metal.icons.*");
        ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), "javax.swing.plaf.basic.icons.*");
    }

    private static void registerHtml32bdtd(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), "javax.swing.text.html.parser.html32.bdtd");
    }

    private static void registerDefaultCSS(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResources(ConfigurationCondition.alwaysTrue(), "javax.swing.text.html.default.css");
    }

    private static NativeLibraries getNativeLibraries(Feature.DuringAnalysisAccess access) {
        FeatureImpl.DuringAnalysisAccessImpl a = (FeatureImpl.DuringAnalysisAccessImpl)access;
        return a.getNativeLibraries();
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }
}

