/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import org.graalvm.collections.Pair;

final class InitKind
extends Enum<InitKind> {
    public static final /* enum */ InitKind BUILD_TIME = new InitKind();
    public static final /* enum */ InitKind RERUN = new InitKind();
    public static final /* enum */ InitKind RUN_TIME = new InitKind();
    public static final String SEPARATOR = ":";
    private static final /* synthetic */ InitKind[] $VALUES;

    public static InitKind[] values() {
        return (InitKind[])$VALUES.clone();
    }

    public static InitKind valueOf(String name) {
        return Enum.valueOf(InitKind.class, name);
    }

    InitKind max(InitKind other) {
        return this.ordinal() > other.ordinal() ? this : other;
    }

    InitKind min(InitKind other) {
        return this.ordinal() < other.ordinal() ? this : other;
    }

    boolean isRunTime() {
        return this.equals((Object)RUN_TIME);
    }

    String suffix() {
        return SEPARATOR + this.name().toLowerCase();
    }

    Consumer<String> stringConsumer(ClassInitializationSupport support, OptionOrigin origin) {
        if (this == RUN_TIME) {
            return name -> support.initializeAtRunTime((String)name, InitKind.reason(origin, name));
        }
        if (this == RERUN) {
            return name -> support.rerunInitialization((String)name, InitKind.reason(origin, name));
        }
        return name -> {
            if (name.equals("") && !NativeImageOptions.DiagnosticsMode.getValue().booleanValue()) {
                System.err.println("--initialize-at-build-time without arguments has been deprecated when not using --diagnostics-mode. With GraalVM 22.0.0 --initialize-at-build-time will only work with --diagnostics-mode for debugging purposes.\nThe reason for deprecation is that --initalize-at-build-time does not compose, i.e., a single library can make assumptions that the whole classpath can be safely initialized at build time; that assumption is often incorrect.");
            }
            support.initializeAtBuildTime((String)name, InitKind.reason(origin, name));
        };
    }

    private static String reason(OptionOrigin origin, String name) {
        return "from " + origin + " with '" + name + "'";
    }

    static Pair<String, InitKind> strip(String input) {
        Optional<InitKind> it = Arrays.stream(InitKind.values()).filter(x -> input.endsWith(x.suffix())).findAny();
        assert (it.isPresent());
        return Pair.create((Object)input.substring(0, input.length() - it.get().suffix().length()), (Object)((Object)it.get()));
    }

    static {
        $VALUES = new InitKind[]{BUILD_TIME, RERUN, RUN_TIME};
    }
}

