/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.SynchAPI;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={PlatformThreads.class})
@Platforms(value={Platform.WINDOWS.class})
public final class WindowsPlatformThreads
extends PlatformThreads {
    private static final CEntryPointLiteral<CFunctionPointer> osThreadStartRoutine = CEntryPointLiteral.create(WindowsPlatformThreads.class, (String)"osThreadStartRoutine", (Class[])new Class[]{WindowsThreadStartData.class});

    @Platforms(value={Platform.HOSTED_ONLY.class})
    WindowsPlatformThreads() {
    }

    @Override
    protected boolean doStartThread(Thread thread, long stackSize) {
        int threadStackSize = (int)stackSize;
        int initFlag = Process.CREATE_SUSPENDED();
        WindowsThreadStartData startData = (WindowsThreadStartData)this.prepareStart(thread, SizeOf.get(WindowsThreadStartData.class));
        if (threadStackSize != 0) {
            initFlag |= Process.STACK_SIZE_PARAM_IS_A_RESERVATION();
        }
        CIntPointer osThreadID = (CIntPointer)StackValue.get(CIntPointer.class);
        WinBase.HANDLE osThreadHandle = Process._beginthreadex(WordFactory.nullPointer(), threadStackSize, (PointerBase)osThreadStartRoutine.getFunctionPointer(), (WordBase)startData, initFlag, osThreadID);
        if (osThreadHandle.isNull()) {
            this.undoPrepareStartOnError(thread, startData);
            return false;
        }
        startData.setOSThreadHandle(osThreadHandle);
        Process.ResumeThread(osThreadHandle);
        return true;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PlatformThreads.OSThreadHandle startThreadUnmanaged(CFunctionPointer threadRoutine, PointerBase userData, int stackSize) {
        int initFlag = 0;
        if (stackSize != 0) {
            initFlag |= Process.STACK_SIZE_PARAM_IS_A_RESERVATION();
        }
        WinBase.HANDLE osThreadHandle = Process.NoTransitions._beginthreadex(WordFactory.nullPointer(), stackSize, (PointerBase)threadRoutine, (WordBase)userData, initFlag, (CIntPointer)WordFactory.nullPointer());
        return (PlatformThreads.OSThreadHandle)((Object)osThreadHandle);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean joinThreadUnmanaged(PlatformThreads.OSThreadHandle threadHandle, WordPointer threadExitStatus) {
        if (SynchAPI.NoTransitions.WaitForSingleObject((WinBase.HANDLE)((Object)threadHandle), SynchAPI.INFINITE()) != SynchAPI.WAIT_OBJECT_0()) {
            return false;
        }
        return Process.NoTransitions.GetExitCodeThread((WinBase.HANDLE)((Object)threadHandle), (CIntPointer)threadExitStatus) != 0;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void closeOSThreadHandle(PlatformThreads.OSThreadHandle threadHandle) {
        WinBase.CloseHandle((WinBase.HANDLE)((Object)threadHandle));
    }

    @Override
    protected void setNativeName(Thread thread, String name) {
    }

    @Override
    protected void yieldCurrent() {
        Process.SwitchToThread();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=OSThreadStartRoutinePrologue.class, epilogue=CEntryPointSetup.LeaveDetachThreadEpilogue.class)
    static WordBase osThreadStartRoutine(WindowsThreadStartData data) {
        ObjectHandle threadHandle = data.getThreadHandle();
        WinBase.HANDLE osThreadHandle = data.getOSThreadHandle();
        WindowsPlatformThreads.freeStartData(data);
        try {
            WindowsPlatformThreads.threadStartRoutine(threadHandle);
        }
        finally {
            WinBase.CloseHandle(osThreadHandle);
        }
        return WordFactory.nullPointer();
    }

    private static class OSThreadStartRoutinePrologue
    implements CEntryPointOptions.Prologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to attach a newly launched thread.");

        private OSThreadStartRoutinePrologue() {
        }

        @Uninterruptible(reason="prologue")
        static void enter(WindowsThreadStartData data) {
            int code = CEntryPointActions.enterAttachThread(data.getIsolate(), true, false);
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }

    @RawStructure
    static interface WindowsThreadStartData
    extends PlatformThreads.ThreadStartData {
        @RawField
        public WinBase.HANDLE getOSThreadHandle();

        @RawField
        public void setOSThreadHandle(WinBase.HANDLE var1);
    }
}

