/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.jvmstat;

import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.jvmstat.PerfManager;
import com.oracle.svm.core.jvmstat.PerfMemoryPrologue;
import com.oracle.svm.core.jvmstat.PerfMemoryProvider;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.jvmstat.Target_jdk_internal_vm_VMSupport;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.util.EnumSet;
import java.util.Set;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

class PosixPerfMemoryProvider
implements PerfMemoryProvider {
    private static final String PERFDATA_NAME = "hsperfdata";
    private Path backingStoreFile;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    PosixPerfMemoryProvider() {
    }

    @Override
    public MappedByteBuffer create() {
        assert (this.backingStoreFile == null);
        int size = NumUtil.roundUp((int)PerfManager.Options.PerfDataMemorySize.getValue(), (int)Unistd.getpagesize());
        if (size <= PerfMemoryPrologue.getPrologueSize()) {
            return null;
        }
        String shortName = String.valueOf(Unistd.getpid());
        String user = System.getProperty("user.name");
        String tmpdir = Target_jdk_internal_vm_VMSupport.getVMTemporaryDirectory();
        if (user.equals("?")) {
            return null;
        }
        String dirname = String.format("%s_%s", PERFDATA_NAME, user);
        Path perfDir = Paths.get(tmpdir, dirname);
        Path filename = perfDir.resolve(shortName);
        PosixPerfMemoryProvider.cleanupOldJvmstatFiles(perfDir, shortName);
        assert (size > 0) : "unexpected PerfDataBuffer region size";
        MappedByteBuffer buffer = PosixPerfMemoryProvider.createSharedBuffer(perfDir, filename, user, size);
        if (buffer == null) {
            return null;
        }
        this.backingStoreFile = filename;
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }

    private static void cleanupOldJvmstatFiles(Path perfDir, String selfName) {
        File[] files = perfDir.toFile().listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            int errno;
            String name = f.getName();
            int pid = PosixPerfMemoryProvider.getPidFromFile(f);
            if (pid == 0) {
                f.delete();
                continue;
            }
            if (name.equals(selfName)) {
                f.delete();
                continue;
            }
            int ret = Signal.kill(pid, 0);
            if (ret != -1 || (errno = LibC.errno()) != Errno.ESRCH() && errno != Errno.EPERM()) continue;
            f.delete();
        }
    }

    private static int getPidFromFile(File file) {
        String name = file.getName();
        try {
            return Integer.parseInt(name);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    private static MappedByteBuffer createSharedBuffer(Path perfDir, Path file, String userName, int size) {
        if (!PosixPerfMemoryProvider.createUserDir(perfDir, userName)) {
            return null;
        }
        EnumSet<PosixFilePermission> perms = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(perms);
        EnumSet<StandardOpenOption> options = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.READ);
        try {
            FileChannel channel = FileChannel.open(file, options, attr);
            return channel.map(FileChannel.MapMode.READ_WRITE, 0L, size);
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static boolean createUserDir(Path userDir, String userName) {
        Path dir = userDir;
        try {
            EnumSet<PosixFilePermission[]> perms = EnumSet.of(PosixFilePermission.OWNER_READ, new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE});
            FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(perms);
            dir = Files.createDirectories(dir, attr);
            return PosixPerfMemoryProvider.isDirSecure(dir, userName);
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static boolean isDirSecure(Path dir, String userName) {
        try {
            if (!Files.isDirectory(dir, LinkOption.NOFOLLOW_LINKS)) {
                return false;
            }
            Set<PosixFilePermission> perms = Files.getPosixFilePermissions(dir, LinkOption.NOFOLLOW_LINKS);
            if (perms.contains((Object)PosixFilePermission.GROUP_WRITE) || perms.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
                return false;
            }
            int euid = Unistd.getegid();
            UserPrincipal euser = Files.getOwner(dir, LinkOption.NOFOLLOW_LINKS);
            if (euid != 0 && !euser.getName().equals(userName)) {
                return false;
            }
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void teardown() {
        if (this.backingStoreFile != null) {
            this.backingStoreFile.toFile().delete();
            this.backingStoreFile = null;
        }
    }
}

