/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.monitor;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.WeakIdentityHashMap;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubCompanion;
import com.oracle.svm.core.monitor.JavaMonitor;
import com.oracle.svm.core.monitor.JavaMonitorQueuedSynchronizer;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.monitor.Target_java_lang_ref_ReferenceQueue_Lock;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.util.VMError;
import java.io.FileDescriptor;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import jdk.internal.misc.Unsafe;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class MultiThreadedMonitorSupport
extends MonitorSupport {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final Set<Class<?>> FORCE_MONITOR_SLOT_TYPES;
    private final Map<Object, JavaMonitor> additionalMonitors = new WeakIdentityHashMap<Object, JavaMonitor>();
    private final ReentrantLock additionalMonitorsLock = new ReentrantLock();
    protected static final String NO_LONGER_UNINTERRUPTIBLE = "The monitor snippet slow path is uninterruptible to avoid stack overflow errors being thrown. Now the yellow zone is enabled and we are no longer uninterruptible, and allocation is allowed again too";

    @Override
    public int getParkedThreadStatus(Thread thread, boolean timed) {
        Object blocker = LockSupport.getBlocker(thread);
        if (blocker instanceof JavaMonitorQueuedSynchronizer.JavaMonitorConditionObject) {
            return timed ? 417 : 401;
        }
        if (blocker instanceof JavaMonitor) {
            return 1025;
        }
        return timed ? 673 : 657;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="Avoid stack overflow error before yellow zone has been activated", calleeMustBe=false)
    private static void slowPathMonitorEnter(Object obj) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        VMOperationControl.guaranteeOkayToBlock("No Java synchronization must be performed within a VMOperation: if the object is already locked, the VM is deadlocked");
        try {
            MultiThreadedMonitorSupport.singleton().monitorEnter(obj);
        }
        catch (OutOfMemoryError ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere("Unexpected exception in MonitorSupport.monitorEnter", ex);
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @Override
    @RestrictHeapAccess(reason="The monitor snippet slow path is uninterruptible to avoid stack overflow errors being thrown. Now the yellow zone is enabled and we are no longer uninterruptible, and allocation is allowed again too", access=RestrictHeapAccess.Access.UNRESTRICTED)
    public void monitorEnter(Object obj) {
        JavaMonitor lockObject = this.getOrCreateMonitor(obj, true);
        lockObject.monitorEnter(obj);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="Avoid stack overflow error before yellow zone has been activated", calleeMustBe=false)
    private static void slowPathMonitorExit(Object obj) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            MultiThreadedMonitorSupport.singleton().monitorExit(obj);
        }
        catch (OutOfMemoryError ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere("Unexpected exception in MonitorSupport.monitorExit", ex);
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @Override
    @RestrictHeapAccess(reason="The monitor snippet slow path is uninterruptible to avoid stack overflow errors being thrown. Now the yellow zone is enabled and we are no longer uninterruptible, and allocation is allowed again too", access=RestrictHeapAccess.Access.UNRESTRICTED)
    public void monitorExit(Object obj) {
        JavaMonitor lockObject = this.getOrCreateMonitor(obj, true);
        lockObject.monitorExit();
    }

    @Override
    public Object prepareRelockObject(Object obj) {
        return this.getOrCreateMonitor(obj, true);
    }

    @Override
    @Uninterruptible(reason="called during deoptimization")
    public void doRelockObject(Object obj, Object lockData) {
        JavaMonitor lock = (JavaMonitor)lockData;
        lock.relockObject();
    }

    @Override
    public boolean isLockedByCurrentThread(Object obj) {
        JavaMonitor lockObject = this.getOrCreateMonitor(obj, false);
        return lockObject != null && lockObject.isHeldByCurrentThread();
    }

    @Override
    public boolean isLockedByAnyThread(Object obj) {
        JavaMonitor lockObject = this.getOrCreateMonitor(obj, false);
        return lockObject != null && lockObject.isLocked();
    }

    @Override
    @SuppressFBWarnings(value={"WA_AWAIT_NOT_IN_LOOP"}, justification="This method is a wait implementation.")
    protected void doWait(Object obj, long timeoutMillis) throws InterruptedException {
        JavaMonitor lock = this.ensureLocked(obj);
        JavaMonitorQueuedSynchronizer.JavaMonitorConditionObject condition = lock.getOrCreateCondition(true);
        if (timeoutMillis == 0L) {
            condition.await(obj);
        } else {
            condition.await(obj, timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void notify(Object obj, boolean notifyAll) {
        JavaMonitor lock = this.ensureLocked(obj);
        JavaMonitorQueuedSynchronizer.JavaMonitorConditionObject condition = lock.getOrCreateCondition(false);
        if (condition != null) {
            if (notifyAll) {
                condition.signalAll();
            } else {
                condition.signal();
            }
        }
    }

    protected JavaMonitor ensureLocked(Object obj) {
        JavaMonitor lockObject = this.getOrCreateMonitor(obj, true);
        if (!lockObject.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Receiver is not locked by the current thread.");
        }
        return lockObject;
    }

    protected static int getMonitorOffset(Object obj) {
        return DynamicHub.fromClass(obj.getClass()).getMonitorOffset();
    }

    protected static Object replaceObject(Object unreplacedObject) {
        if (unreplacedObject instanceof DynamicHub) {
            return ((DynamicHub)unreplacedObject).getCompanion();
        }
        return unreplacedObject;
    }

    protected final JavaMonitor getOrCreateMonitor(Object unreplacedObject, boolean createIfNotExisting) {
        Object obj = MultiThreadedMonitorSupport.replaceObject(unreplacedObject);
        assert (obj != null);
        int monitorOffset = MultiThreadedMonitorSupport.getMonitorOffset(obj);
        if (monitorOffset != 0) {
            return this.getOrCreateMonitorFromObject(obj, createIfNotExisting, monitorOffset);
        }
        return this.getOrCreateMonitorFromMap(obj, createIfNotExisting);
    }

    protected JavaMonitor getOrCreateMonitorFromObject(Object obj, boolean createIfNotExisting, int monitorOffset) {
        JavaMonitor existingMonitor = (JavaMonitor)BarrieredAccess.readObject((Object)obj, (int)monitorOffset);
        if (existingMonitor != null || !createIfNotExisting) {
            return existingMonitor;
        }
        JavaMonitor newMonitor = MultiThreadedMonitorSupport.newMonitorLock();
        if (UNSAFE.compareAndSetObject(obj, monitorOffset, null, newMonitor)) {
            return newMonitor;
        }
        return (JavaMonitor)BarrieredAccess.readObject((Object)obj, (int)monitorOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaMonitor getOrCreateMonitorFromMap(Object obj, boolean createIfNotExisting) {
        assert (JavaVersionUtil.JAVA_SPEC > 19 || obj.getClass() != Target_java_lang_ref_ReferenceQueue_Lock.class) : "ReferenceQueue.Lock must have a monitor field or we can deadlock accessing WeakIdentityHashMap below";
        VMError.guarantee(!this.additionalMonitorsLock.isHeldByCurrentThread(), "Recursive manipulation of the additionalMonitors map can lead to table corruptions and double insertion of a monitor for the same object");
        this.additionalMonitorsLock.lock();
        try {
            JavaMonitor existingMonitor = this.additionalMonitors.get(obj);
            if (existingMonitor != null || !createIfNotExisting) {
                JavaMonitor javaMonitor = existingMonitor;
                return javaMonitor;
            }
            JavaMonitor newMonitor = MultiThreadedMonitorSupport.newMonitorLock();
            JavaMonitor previousEntry = this.additionalMonitors.put(obj, newMonitor);
            VMError.guarantee(previousEntry == null, "Replaced monitor in secondary storage map");
            JavaMonitor javaMonitor = newMonitor;
            return javaMonitor;
        }
        finally {
            this.additionalMonitorsLock.unlock();
        }
    }

    protected static JavaMonitor newMonitorLock() {
        return new JavaMonitor();
    }

    static {
        try {
            HashSet monitorTypes = new HashSet();
            if (JavaVersionUtil.JAVA_SPEC <= 17) {
                monitorTypes.add(Class.forName("java.lang.ref.ReferenceQueue$Lock"));
            }
            monitorTypes.add(ReferenceQueue.class);
            monitorTypes.add(FileDescriptor.class);
            monitorTypes.add(Object.class);
            monitorTypes.add(Class.forName("com.oracle.svm.core.jdk.SplittableRandomAccessors"));
            if (JavaVersionUtil.JAVA_SPEC >= 11) {
                monitorTypes.add(Class.forName("jdk.internal.ref.PhantomCleanable"));
            }
            monitorTypes.add(DynamicHubCompanion.class);
            FORCE_MONITOR_SLOT_TYPES = Collections.unmodifiableSet(monitorTypes);
        }
        catch (ClassNotFoundException e) {
            throw VMError.shouldNotReachHere("Error building the list of types that always need a monitor slot.", e);
        }
    }
}

