/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.locks;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class VMCondition {
    protected final VMMutex mutex;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public VMCondition(VMMutex mutex) {
        this.mutex = mutex;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public VMMutex getMutex() {
        return this.mutex;
    }

    public void block() {
        throw VMError.shouldNotReachHere("VMCondition cannot be used during native image generation");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", callerMustBe=true)
    public void blockNoTransition() {
        throw VMError.shouldNotReachHere("VMCondition cannot be used during native image generation");
    }

    public long block(long nanoseconds) {
        throw VMError.shouldNotReachHere("VMCondition cannot be used during native image generation");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", callerMustBe=true)
    public long blockNoTransition(long nanoseconds) {
        throw VMError.shouldNotReachHere("VMCondition cannot be used during native image generation");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", callerMustBe=true)
    public void blockNoTransitionUnspecifiedOwner() {
        throw VMError.shouldNotReachHere("VMCondition cannot be used during native image generation");
    }

    public void signal() {
        throw VMError.shouldNotReachHere("VMCondition cannot be used during native image generation");
    }

    public void broadcast() {
        throw VMError.shouldNotReachHere("VMCondition cannot be used during native image generation");
    }
}

