/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmstat;

import com.oracle.svm.core.IsolateArgumentParser;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jvmstat.MutablePerfDataEntry;
import com.oracle.svm.core.jvmstat.PerfDataHolder;
import com.oracle.svm.core.jvmstat.PerfLong;
import com.oracle.svm.core.jvmstat.PerfLongConstant;
import com.oracle.svm.core.jvmstat.PerfLongCounter;
import com.oracle.svm.core.jvmstat.PerfLongVariable;
import com.oracle.svm.core.jvmstat.PerfMemory;
import com.oracle.svm.core.jvmstat.PerfStringConstant;
import com.oracle.svm.core.jvmstat.PerfStringVariable;
import com.oracle.svm.core.jvmstat.PerfUnit;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.word.WordFactory;

public class PerfManager {
    private final ArrayList<PerfDataHolder> perfDataHolders = new ArrayList();
    private final ArrayList<MutablePerfDataEntry> mutablePerfDataEntries = new ArrayList();
    private final EconomicMap<String, PerfLong> longEntries = EconomicMap.create();
    private final PerfDataThread perfDataThread = new PerfDataThread(this);
    private long startTime;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PerfManager() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void register(PerfDataHolder perfDataHolder) {
        this.perfDataHolders.add(perfDataHolder);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PerfLongConstant createLongConstant(String name, PerfUnit unit) {
        PerfLongConstant result = new PerfLongConstant(name, unit);
        this.longEntries.put((Object)name, (Object)result);
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PerfLongCounter createLongCounter(String name, PerfUnit unit) {
        PerfLongCounter result = new PerfLongCounter(name, unit);
        this.mutablePerfDataEntries.add(result);
        this.longEntries.put((Object)name, (Object)result);
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PerfLongVariable createLongVariable(String name, PerfUnit unit) {
        PerfLongVariable result = new PerfLongVariable(name, unit);
        this.mutablePerfDataEntries.add(result);
        this.longEntries.put((Object)name, (Object)result);
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PerfStringConstant createStringConstant(String name) {
        return new PerfStringConstant(name);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PerfStringVariable createStringVariable(String name, int lengthInBytes) {
        PerfStringVariable result = new PerfStringVariable(name, lengthInBytes);
        this.mutablePerfDataEntries.add(result);
        return result;
    }

    public static boolean usePerfData() {
        int optionIndex = IsolateArgumentParser.getOptionIndex(SubstrateOptions.ConcealedOptions.UsePerfData);
        return VMInspectionOptions.hasJvmstatSupport() && IsolateArgumentParser.getBooleanOptionValue(optionIndex);
    }

    public CLongPointer getLongPerfEntry(String name) {
        this.waitForInitialization();
        PerfLong entry = (PerfLong)this.longEntries.get((Object)name);
        assert (Heap.getHeap().isInImageHeap(entry));
        return (CLongPointer)Word.objectToUntrackedPointer((Object)entry).add((Word)WordFactory.unsigned((long)PerfLong.VALUE_OFFSET));
    }

    public boolean hasLongPerfEntry(String name) {
        this.waitForInitialization();
        PerfLong entry = (PerfLong)this.longEntries.get((Object)name);
        return Heap.getHeap().isInImageHeap(entry);
    }

    public void waitForInitialization() {
        if (!PerfManager.usePerfData() || !this.perfDataThread.waitForInitialization()) {
            throw new IllegalArgumentException("Performance data support is disabled.");
        }
    }

    private void allocate() {
        for (PerfDataHolder perfDataHolder : this.perfDataHolders) {
            perfDataHolder.allocate();
        }
    }

    public long elapsedTicks() {
        return System.nanoTime() - this.startTime;
    }

    public RuntimeSupport.Hook initializationHook() {
        return isFirstIsolate -> {
            if (PerfManager.usePerfData()) {
                this.startTime = System.nanoTime();
                this.perfDataThread.start();
            }
        };
    }

    public RuntimeSupport.Hook teardownHook() {
        return isFirstIsolate -> {
            if (PerfManager.usePerfData()) {
                this.perfDataThread.shutdown();
                PerfMemory memory = (PerfMemory)ImageSingletons.lookup(PerfMemory.class);
                memory.teardown();
            }
        };
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> PerfDataMemoryMappedFile = new HostedOptionKey<Boolean>(true);
        public static final RuntimeOptionKey<Integer> PerfDataMemorySize = new RuntimeOptionKey<Integer>(Integer.valueOf(32768), RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
        public static final RuntimeOptionKey<Integer> PerfDataSamplingInterval = new RuntimeOptionKey<Integer>(Integer.valueOf(200), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        public static final RuntimeOptionKey<Integer> PerfMaxStringConstLength = new RuntimeOptionKey<Integer>(Integer.valueOf(1024), RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
    }

    private static class PerfDataThread
    extends Thread {
        private static final String ERROR_DURING_INITIALIZATION = "Failed while initializing the performance data.";
        private final PerfManager manager;
        private final VMMutex initializationMutex;
        private final VMCondition initializationCondition;
        private volatile boolean initialized;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        PerfDataThread(PerfManager manager) {
            super("Performance data");
            this.manager = manager;
            this.initializationMutex = new VMMutex("perfDataInitialization");
            this.initializationCondition = new VMCondition(this.initializationMutex);
            this.initialized = false;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            this.initializeMemory();
            try {
                this.sampleData();
                ((PerfMemory)ImageSingletons.lookup(PerfMemory.class)).setAccessible();
                while (true) {
                    Thread.sleep(Options.PerfDataSamplingInterval.getValue().intValue());
                    this.sampleData();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        private void initializeMemory() {
            this.initializationMutex.lock();
            try {
                PerfMemory memory = (PerfMemory)ImageSingletons.lookup(PerfMemory.class);
                boolean success = memory.initialize();
                VMError.guarantee(success, ERROR_DURING_INITIALIZATION);
                this.manager.allocate();
                this.initialized = true;
                this.initializationCondition.broadcast();
            }
            catch (Throwable e) {
                VMError.shouldNotReachHere(ERROR_DURING_INITIALIZATION, e);
            }
            finally {
                this.initializationMutex.unlock();
            }
        }

        public void sampleData() {
            ArrayList<PerfDataHolder> perfDataHolders = this.manager.perfDataHolders;
            for (int i = 0; i < perfDataHolders.size(); ++i) {
                perfDataHolders.get(i).update();
            }
            ArrayList<MutablePerfDataEntry> mutablePerfDataEntries = this.manager.mutablePerfDataEntries;
            for (int i = 0; i < mutablePerfDataEntries.size(); ++i) {
                mutablePerfDataEntries.get(i).publish();
            }
        }

        public boolean waitForInitialization() {
            if (this.initialized) {
                return true;
            }
            this.initializationMutex.lock();
            try {
                if (!this.initialized) {
                    if (!this.isAlive()) {
                        boolean bl = false;
                        return bl;
                    }
                    this.initializationCondition.block();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.initializationMutex.unlock();
            }
        }

        public void shutdown() {
            this.waitForInitialization();
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException e) {
                throw VMError.shouldNotReachHere("Shutdown hook should not be interrupted");
            }
        }
    }
}

