/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_EventWriter;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import jdk.internal.misc.Unsafe;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JfrEventWriterAccess {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final Field startPosition;
    private static final Field startPositionAddress;
    private static final Field currentPosition;
    private static final Field maxPosition;
    private static final Field valid;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Class<?> getEventWriterClass() {
        String className = JavaVersionUtil.JAVA_SPEC >= 19 ? "jdk.jfr.internal.event.EventWriter" : "jdk.jfr.internal.EventWriter";
        return ReflectionUtil.lookupClass((boolean)false, (String)className);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JfrEventWriterAccess() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setStartPosition(Target_jdk_jfr_internal_EventWriter writer, long value) {
        UNSAFE.putLong(writer, UNSAFE.objectFieldOffset(startPosition), value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setStartPositionAddress(Target_jdk_jfr_internal_EventWriter writer, long value) {
        UNSAFE.putLong(writer, UNSAFE.objectFieldOffset(startPositionAddress), value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setCurrentPosition(Target_jdk_jfr_internal_EventWriter writer, long value) {
        UNSAFE.putLong(writer, UNSAFE.objectFieldOffset(currentPosition), value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setMaxPosition(Target_jdk_jfr_internal_EventWriter writer, long value) {
        UNSAFE.putLong(writer, UNSAFE.objectFieldOffset(maxPosition), value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setValid(Target_jdk_jfr_internal_EventWriter writer, boolean value) {
        UNSAFE.putBooleanVolatile(writer, UNSAFE.objectFieldOffset(valid), value);
    }

    static {
        Class<?> declaringClass = JfrEventWriterAccess.getEventWriterClass();
        startPosition = ReflectionUtil.lookupField(declaringClass, (String)"startPosition");
        startPositionAddress = ReflectionUtil.lookupField(declaringClass, (String)"startPositionAddress");
        currentPosition = ReflectionUtil.lookupField(declaringClass, (String)"currentPosition");
        maxPosition = ReflectionUtil.lookupField(declaringClass, (String)"maxPosition");
        valid = ReflectionUtil.lookupField(declaringClass, (String)"valid");
    }
}

