/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.ImageHeapMap;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
public class ClassLoadingExceptionSupport {
    private static final int EXIT_CODE = 172;
    private final EconomicMap<String, Throwable> inaccessibleClasses = ImageHeapMap.create();

    static ClassLoadingExceptionSupport singleton() {
        return (ClassLoadingExceptionSupport)ImageSingletons.lookup(ClassLoadingExceptionSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerClass(String className, Throwable t) {
        ClassLoadingExceptionSupport.singleton().inaccessibleClasses.put((Object)className, (Object)t);
    }

    public static Throwable getExceptionForClass(String className, Throwable original) {
        Throwable t = (Throwable)ClassLoadingExceptionSupport.singleton().inaccessibleClasses.get((Object)className);
        if (t == null && Options.ExitOnUnknownClassLoadingFailure.getValue().booleanValue()) {
            ClassLoadingExceptionSupport.terminateUnconfigured(className);
        }
        if (t == null || t.getClass() == original.getClass()) {
            return original;
        }
        return t;
    }

    private static void terminateUnconfigured(String className) {
        System.err.println("Missing metadata error: Unable to process Class.forName invocation for class name " + className);
        System.exit(172);
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> ExitOnUnknownClassLoadingFailure = new HostedOptionKey<Boolean>(false);
    }
}

