/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.ReferenceAdjuster;
import com.oracle.svm.core.meta.DirectSubstrateObjectConstant;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;

public class InstantReferenceAdjuster
implements ReferenceAdjuster {
    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T> void setObjectInArray(NonmovableObjectArray<T> array, int index, T object) {
        NonmovableArrays.setObject(array, index, object);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T> void setConstantTargetInArray(NonmovableObjectArray<T> array, int index, SubstrateObjectConstant constant) {
        NonmovableArrays.setObject(array, index, ((DirectSubstrateObjectConstant)constant).getObject());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setConstantTargetAt(PointerBase address, int length, SubstrateObjectConstant constant) {
        ReferenceAdjuster.writeReference((Pointer)address, length, ((DirectSubstrateObjectConstant)constant).getObject());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T> NonmovableObjectArray<T> copyOfObjectArray(T[] source) {
        return NonmovableArrays.copyOfObjectArray(source);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isFinished() {
        return true;
    }
}

