/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.truffle.api.CompilerDirectives;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;

public class TruffleBoundaryPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        for (Invoke n : graph.getInvokes()) {
            ResolvedJavaMethod targetMethod;
            CompilerDirectives.TruffleBoundary truffleBoundary;
            InvokeWithExceptionNode invoke;
            ExceptionObjectNode exceptionObject;
            FixedNode originalNext;
            if (!(n instanceof InvokeWithExceptionNode) || (originalNext = (exceptionObject = (ExceptionObjectNode)(invoke = (InvokeWithExceptionNode)n).exceptionEdge()).next()) instanceof DeoptimizeNode || invoke.callTarget().targetMethod() == null || (truffleBoundary = (CompilerDirectives.TruffleBoundary)(targetMethod = invoke.callTarget().targetMethod()).getAnnotation(CompilerDirectives.TruffleBoundary.class)) == null || !truffleBoundary.transferToInterpreterOnException()) continue;
            TruffleBoundaryPhase.addDeoptimizeNode(graph, originalNext, targetMethod);
        }
    }

    private static void addDeoptimizeNode(StructuredGraph graph, FixedNode originalNext, ResolvedJavaMethod targetMethod) {
        SpeculationLog.SpeculationReason speculationReason;
        SpeculationLog speculationLog = graph.getSpeculationLog();
        if (speculationLog != null && speculationLog.maySpeculate(speculationReason = PartialEvaluator.createTruffleBoundaryExceptionSpeculation((ResolvedJavaMethod)targetMethod))) {
            SpeculationLog.Speculation exceptionSpeculation = speculationLog.speculate(speculationReason);
            DeoptimizeNode deoptimize = (DeoptimizeNode)graph.add((Node)new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.TransferToInterpreter, exceptionSpeculation));
            originalNext.replaceAtPredecessor((Node)deoptimize);
            GraphUtil.killCFG((FixedNode)originalNext);
        }
    }
}

