/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.annotate.MustNotSynchronize;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.MonitorEnterNode;
import org.graalvm.compiler.options.Option;

public final class MustNotSynchronizeAnnotationChecker {
    private final Collection<HostedMethod> methods;
    private final Deque<HostedMethod> methodPath;
    private final Deque<HostedMethod> methodImplPath;

    private MustNotSynchronizeAnnotationChecker(Collection<HostedMethod> methods) {
        this.methods = methods;
        this.methodPath = new ArrayDeque<HostedMethod>();
        this.methodImplPath = new ArrayDeque<HostedMethod>();
    }

    public static void check(DebugContext debug, Collection<HostedMethod> methods) {
        MustNotSynchronizeAnnotationChecker checker = new MustNotSynchronizeAnnotationChecker(methods);
        checker.checkMethods(debug);
    }

    public void checkMethods(DebugContext debug) {
        for (HostedMethod method : this.methods) {
            try {
                DebugContext.Scope s = debug.scope((Object)"MustNotSynchronizeAnnotationChecker", (Object)method.compilationInfo.graph, (Object)method, (Object)this);
                Throwable throwable = null;
                try {
                    MustNotSynchronize annotation = method.getAnnotation(MustNotSynchronize.class);
                    if (annotation == null || !annotation.list()) continue;
                    this.methodPath.clear();
                    this.methodImplPath.clear();
                    try {
                        this.checkMethod(method, method);
                    }
                    catch (WarningException we) {
                        throw new WarningException(we.getMessage());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (s == null) continue;
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    s.close();
                }
            }
            catch (Throwable t) {
                throw debug.handle(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkMethod(HostedMethod method, HostedMethod methodImpl) throws WarningException {
        if (this.methodImplPath.contains(methodImpl)) {
            return false;
        }
        MustNotSynchronize annotation = methodImpl.getAnnotation(MustNotSynchronize.class);
        if (annotation != null && !annotation.list()) {
            return false;
        }
        this.methodPath.push(method);
        this.methodImplPath.push(methodImpl);
        try {
            if (this.synchronizesDirectly(methodImpl)) {
                boolean bl = true;
                return bl;
            }
            if (this.synchronizesIndirectly(methodImpl)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.methodPath.pop();
            this.methodImplPath.pop();
        }
    }

    protected boolean synchronizesDirectly(HostedMethod methodImpl) throws WarningException {
        StructuredGraph graph = methodImpl.compilationInfo.getGraph();
        if (graph != null) {
            for (Node node : graph.getNodes()) {
                if (!(node instanceof MonitorEnterNode)) continue;
                this.postMustNotSynchronizeWarning();
                return true;
            }
        }
        return false;
    }

    protected boolean synchronizesIndirectly(HostedMethod methodImpl) throws WarningException {
        boolean result = false;
        StructuredGraph graph = methodImpl.compilationInfo.getGraph();
        if (graph != null) {
            for (Invoke invoke : graph.getInvokes()) {
                HostedMethod callee = (HostedMethod)invoke.callTarget().targetMethod();
                if (invoke.callTarget().invokeKind().isDirect()) {
                    if (!(result |= this.checkMethod(callee, callee))) continue;
                    return result;
                }
                for (HostedMethod calleeImpl : callee.getImplementations()) {
                    if (!(result |= this.checkMethod(callee, calleeImpl))) continue;
                    return result;
                }
            }
        }
        return result;
    }

    private void postMustNotSynchronizeWarning() throws WarningException {
        HostedMethod blacklistMethod = this.methodPath.getLast();
        String message = "@MustNotSynchronize warning: ";
        if (this.methodPath.size() == 1) {
            message = message + "Blacklisted method: " + blacklistMethod.format("%h.%n(%p)") + " synchronizes.";
        } else {
            HostedMethod witness = this.methodPath.getFirst();
            message = message + "Blacklisted method: " + blacklistMethod.format("%h.%n(%p)") + " calls " + witness.format("%h.%n(%p)") + " that synchronizes.";
        }
        if (Options.PrintMustNotSynchronizeWarnings.getValue().booleanValue()) {
            System.err.println(message);
            if (Options.PrintMustNotSynchronizePath.getValue().booleanValue() && 1 < this.methodPath.size()) {
                this.printPath();
            }
        }
        if (Options.MustNotSynchronizeWarningsAreFatal.getValue().booleanValue()) {
            throw new WarningException(message);
        }
    }

    private void printPath() {
        System.out.print("  [Path: ");
        Iterator<HostedMethod> methodIterator = this.methodPath.iterator();
        Iterator<HostedMethod> methodImplIterator = this.methodImplPath.iterator();
        while (methodIterator.hasNext()) {
            HostedMethod method = methodIterator.next();
            HostedMethod methodImpl = methodImplIterator.next();
            System.err.println();
            if (method.equals(methodImpl)) {
                System.err.print("     " + method.format("%h.%n(%p)"));
                continue;
            }
            System.err.print("     " + method.format("%f %h.%n(%p)") + " implemented by " + methodImpl.format("%h.%n(%p)"));
        }
        System.err.println("]");
    }

    public static class WarningException
    extends Exception {
        private static final long serialVersionUID = 5793144021924912791L;

        public WarningException(String message) {
            super(message);
        }
    }

    public static class Options {
        @Option(help={"Print warnings for @MustNotSynchronize annotations."})
        public static final HostedOptionKey<Boolean> PrintMustNotSynchronizeWarnings = new HostedOptionKey<Boolean>(true);
        @Option(help={"Print path for @MustNotSynchronize warnings."})
        public static final HostedOptionKey<Boolean> PrintMustNotSynchronizePath = new HostedOptionKey<Boolean>(true);
        @Option(help={"Warnings for @MustNotSynchronize annotations are fatal."})
        public static final HostedOptionKey<Boolean> MustNotSynchronizeWarningsAreFatal = new HostedOptionKey<Boolean>(true);
    }
}

