/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.snippets;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.jdk.JDKUtils;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.util.DirectAnnotationAccess;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class SnippetRuntime {
    public static final SubstrateForeignCallDescriptor UNSUPPORTED_FEATURE = SnippetRuntime.findForeignCall(SnippetRuntime.class, "unsupportedFeature", true, LocationIdentity.any());
    public static final SubstrateForeignCallDescriptor UNWIND_EXCEPTION = SnippetRuntime.findForeignCall(SnippetRuntime.class, "unwindException", true, LocationIdentity.any());
    public static final SubstrateForeignCallDescriptor REGISTER_FINALIZER = SnippetRuntime.findForeignCall(SnippetRuntime.class, "registerFinalizer", true, new LocationIdentity[0]);
    public static final SubstrateForeignCallDescriptor ARITHMETIC_SIN = SnippetRuntime.findForeignCall(UnaryMathIntrinsicNode.UnaryOperation.SIN.foreignCallDescriptor.getName(), Math.class, "sin", true, new LocationIdentity[0]);
    public static final SubstrateForeignCallDescriptor ARITHMETIC_COS = SnippetRuntime.findForeignCall(UnaryMathIntrinsicNode.UnaryOperation.COS.foreignCallDescriptor.getName(), Math.class, "cos", true, new LocationIdentity[0]);
    public static final SubstrateForeignCallDescriptor ARITHMETIC_TAN = SnippetRuntime.findForeignCall(UnaryMathIntrinsicNode.UnaryOperation.TAN.foreignCallDescriptor.getName(), Math.class, "tan", true, new LocationIdentity[0]);
    public static final SubstrateForeignCallDescriptor ARITHMETIC_LOG = SnippetRuntime.findForeignCall(UnaryMathIntrinsicNode.UnaryOperation.LOG.foreignCallDescriptor.getName(), Math.class, "log", true, new LocationIdentity[0]);
    public static final SubstrateForeignCallDescriptor ARITHMETIC_LOG10 = SnippetRuntime.findForeignCall(UnaryMathIntrinsicNode.UnaryOperation.LOG10.foreignCallDescriptor.getName(), Math.class, "log10", true, new LocationIdentity[0]);
    public static final SubstrateForeignCallDescriptor ARITHMETIC_EXP = SnippetRuntime.findForeignCall(UnaryMathIntrinsicNode.UnaryOperation.EXP.foreignCallDescriptor.getName(), Math.class, "exp", true, new LocationIdentity[0]);
    public static final SubstrateForeignCallDescriptor ARITHMETIC_POW = SnippetRuntime.findForeignCall(BinaryMathIntrinsicNode.BinaryOperation.POW.foreignCallDescriptor.getName(), Math.class, "pow", true, new LocationIdentity[0]);
    public static final SubstrateForeignCallDescriptor OBJECT_CLONE = SnippetRuntime.findForeignCall(Object.class, "clone", false, LocationIdentity.any());
    public static final FastThreadLocalObject<Throwable> currentException = FastThreadLocalFactory.createObject(Throwable.class);

    public static List<SubstrateForeignCallDescriptor> getRuntimeCalls() {
        ArrayList<SubstrateForeignCallDescriptor> result = new ArrayList<SubstrateForeignCallDescriptor>();
        try {
            for (Field field : SnippetRuntime.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || field.getType() != SubstrateForeignCallDescriptor.class) continue;
                result.add((SubstrateForeignCallDescriptor)((Object)field.get(null)));
            }
        }
        catch (IllegalAccessException ex) {
            throw new Error(ex);
        }
        return result;
    }

    public static SubstrateForeignCallDescriptor findForeignCall(Class<?> declaringClass, String methodName, boolean isReexecutable, LocationIdentity ... killedLocations) {
        return SnippetRuntime.findForeignCall(methodName, declaringClass, methodName, isReexecutable, killedLocations);
    }

    public static SubstrateForeignCallDescriptor findForeignCall(Class<?> declaringClass, String methodName, boolean isReexecutable, boolean needsDebugInfo, LocationIdentity ... killedLocations) {
        return SnippetRuntime.findForeignCall(methodName, declaringClass, methodName, isReexecutable, needsDebugInfo, killedLocations);
    }

    private static SubstrateForeignCallDescriptor findForeignCall(String descriptorName, Class<?> declaringClass, String methodName, boolean isReexecutable, LocationIdentity ... killedLocations) {
        return SnippetRuntime.findForeignCall(descriptorName, declaringClass, methodName, isReexecutable, true, killedLocations);
    }

    private static SubstrateForeignCallDescriptor findForeignCall(String descriptorName, Class<?> declaringClass, String methodName, boolean isReexecutable, boolean needsDebugInfo, LocationIdentity ... killedLocations) {
        Method foundMethod = null;
        for (Method method : declaringClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            assert (foundMethod == null) : "found more than one method " + declaringClass.getName() + "." + methodName;
            foundMethod = method;
        }
        assert (foundMethod != null) : "did not find method " + declaringClass.getName() + "." + methodName;
        VMError.guarantee(declaringClass.getName().startsWith("java.lang") || DirectAnnotationAccess.isAnnotationPresent(foundMethod, SubstrateForeignCallTarget.class), "Add missing @SubstrateForeignCallTarget to " + declaringClass.getName() + "." + methodName);
        boolean isGuaranteedSafepoint = needsDebugInfo && !DirectAnnotationAccess.isAnnotationPresent((AnnotatedElement)foundMethod, Uninterruptible.class);
        return new SubstrateForeignCallDescriptor(descriptorName, foundMethod, isReexecutable, killedLocations, needsDebugInfo, isGuaranteedSafepoint);
    }

    @SubstrateForeignCallTarget
    private static void unsupportedFeature(String msg) {
        throw VMError.unsupportedFeature(msg);
    }

    @Uninterruptible(reason="Called from uninterruptible callers.", mayBeInlined=true)
    static boolean exceptionsAreFatal() {
        return SubstrateOptions.MultiThreaded.getValue() != false && !VMThreads.StatusSupport.isStatusJava();
    }

    @SubstrateForeignCallTarget
    @Uninterruptible(reason="Must not execute recurring callbacks or a stack overflow check.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when unwinding the stack.")
    private static void unwindException(Throwable exception, Pointer callerSP) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        ThreadingSupportImpl.pauseRecurringCallback("Arbitrary code must not be executed while unwinding.");
        if (currentException.get() != null) {
            Log.log().string("Fatal error: recursion in exception handling: ").string(exception.getClass().getName());
            Log.log().string(" thrown while unwinding ").string(currentException.get().getClass().getName()).newline();
            ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
            return;
        }
        currentException.set(exception);
        if (SnippetRuntime.exceptionsAreFatal()) {
            Log.log().string("Fatal error: exception unwind while thread is not in Java state: ").string(exception.getClass().getName());
            ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
            return;
        }
        ((ExceptionUnwind)ImageSingletons.lookup(ExceptionUnwind.class)).unwindException(callerSP);
        SnippetRuntime.reportUnhandledExceptionRaw(exception);
    }

    private static void reportUnhandledExceptionRaw(Throwable exception) {
        Log.log().string(exception.getClass().getName());
        String detail = JDKUtils.getRawMessage(exception);
        if (detail != null) {
            Log.log().string(": ").string(detail);
        }
        Log.log().newline();
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
    }

    @SubstrateForeignCallTarget
    private static void registerFinalizer(Object obj) {
    }

    public static class ExceptionUnwind {
        private static final ExceptionStackFrameVisitor stackFrameVisitor = new ExceptionStackFrameVisitor();

        public void unwindException(Pointer callerSP) {
            ExceptionUnwind.walkInline(callerSP);
        }

        @Uninterruptible(reason="Avoid the virtual call to the visitor.")
        private static void walkInline(Pointer callerSP) {
            JavaStackWalker.walkCurrentThreadInline(callerSP, stackFrameVisitor);
        }
    }

    public static class ExceptionStackFrameVisitor
    implements StackFrameVisitor {
        @Override
        @Uninterruptible(reason="Deoptimization; set currentException atomically with regard to the safepoint mechanism")
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate when unwinding the stack.")
        public boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame initialDeoptFrame) {
            CodePointer handlerIP = (CodePointer)WordFactory.nullPointer();
            DeoptimizedFrame deoptFrame = initialDeoptFrame;
            if (deoptFrame == null) {
                long handler = ExceptionStackFrameVisitor.lookupExceptionOffset(codeInfo, ip);
                if (handler == 0L) {
                    return true;
                }
                handlerIP = (CodePointer)((UnsignedWord)ip).add((UnsignedWord)WordFactory.signed((long)handler));
                deoptFrame = Deoptimizer.checkDeoptimized(sp);
            }
            if (deoptFrame != null && DeoptimizationSupport.enabled()) {
                ExceptionStackFrameVisitor.deoptTakeException(deoptFrame);
                handlerIP = DeoptimizationSupport.getDeoptStubPointer();
            }
            Throwable exception = currentException.get();
            currentException.set(null);
            ThreadingSupportImpl.resumeRecurringCallbackAtNextSafepoint();
            StackOverflowCheck.singleton().protectYellowZone();
            KnownIntrinsics.farReturn(exception, sp, handlerIP);
            return false;
        }

        @Uninterruptible(reason="Wrap call to interruptible code.", calleeMustBe=false)
        private static void deoptTakeException(DeoptimizedFrame deoptFrame) {
            deoptFrame.takeException();
        }

        @Uninterruptible(reason="Wrap call to interruptible code.", calleeMustBe=false)
        private static long lookupExceptionOffset(CodeInfo codeInfo, CodePointer ip) {
            return CodeInfoAccess.lookupExceptionOffset(codeInfo, CodeInfoAccess.relativeIP(codeInfo, ip));
        }
    }

    public static class SubstrateForeignCallDescriptor
    extends ForeignCallDescriptor {
        private final Class<?> declaringClass;
        private final String methodName;
        private final boolean isReexecutable;
        private final LocationIdentity[] killedLocations;
        private final boolean needsDebugInfo;
        private final boolean isGuaranteedSafepoint;

        SubstrateForeignCallDescriptor(String descriptorName, Method method, boolean isReexecutable, LocationIdentity[] killedLocations, boolean needsDebugInfo, boolean isGuaranteedSafepoint) {
            super(descriptorName, method.getReturnType(), (Class[])method.getParameterTypes());
            this.declaringClass = method.getDeclaringClass();
            this.methodName = method.getName();
            this.isReexecutable = isReexecutable;
            this.killedLocations = killedLocations;
            this.needsDebugInfo = needsDebugInfo;
            this.isGuaranteedSafepoint = isGuaranteedSafepoint;
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public boolean isReexecutable() {
            return this.isReexecutable;
        }

        public ResolvedJavaMethod findMethod(MetaAccessProvider metaAccess) {
            for (Method method : this.declaringClass.getDeclaredMethods()) {
                if (!method.getName().equals(this.methodName)) continue;
                return metaAccess.lookupJavaMethod((Executable)method);
            }
            throw VMError.shouldNotReachHere("method " + this.methodName + " not found");
        }

        public LocationIdentity[] getKilledLocations() {
            return this.killedLocations;
        }

        public boolean needsDebugInfo() {
            return this.needsDebugInfo;
        }

        public boolean isGuaranteedSafepoint() {
            return this.isGuaranteedSafepoint;
        }
    }
}

