/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.snippets;

import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.util.VMError;
import org.graalvm.word.LocationIdentity;

@InternalVMMethod
public class ImplicitExceptions {
    public static final String NO_STACK_MSG = "[no exception stack trace available because exception is thrown from code that must be allocation free]";
    public static final NullPointerException CACHED_NULL_POINTER_EXCEPTION = new NullPointerException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final ArrayIndexOutOfBoundsException CACHED_OUT_OF_BOUNDS_EXCEPTION = new ArrayIndexOutOfBoundsException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final ClassCastException CACHED_CLASS_CAST_EXCEPTION = new ClassCastException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final ArrayStoreException CACHED_ARRAY_STORE_EXCEPTION = new ArrayStoreException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final ArithmeticException CACHED_ARITHMETIC_EXCEPTION = new ArithmeticException("[no exception stack trace available because exception is thrown from code that must be allocation free]");
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_NULL_POINTER_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createNullPointerException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_OUT_OF_BOUNDS_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createOutOfBoundsException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_CLASS_CAST_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createClassCastException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_ARRAY_STORE_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createArrayStoreException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_DIVISION_BY_ZERO_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "createDivisionByZeroException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_NULL_POINTER_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewNullPointerException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_OUT_OF_BOUNDS_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewOutOfBoundsException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_OUT_OF_BOUNDS_EXCEPTION_WITH_ARGS = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewOutOfBoundsExceptionWithArgs", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_CLASS_CAST_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewClassCastException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_CLASS_CAST_EXCEPTION_WITH_ARGS = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewClassCastExceptionWithArgs", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_ARRAY_STORE_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewArrayStoreException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_ARRAY_STORE_EXCEPTION_WITH_ARGS = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewArrayStoreExceptionWithArgs", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_ARITHMETIC_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewArithmeticException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_NEW_DIVISION_BY_ZERO_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwNewDivisionByZeroException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor GET_CACHED_NULL_POINTER_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "getCachedNullPointerException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor GET_CACHED_OUT_OF_BOUNDS_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "getCachedOutOfBoundsException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor GET_CACHED_CLASS_CAST_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "getCachedClassCastException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor GET_CACHED_ARRAY_STORE_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "getCachedArrayStoreException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor GET_CACHED_ARITHMETIC_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "getCachedArithmeticException", false, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_NULL_POINTER_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedNullPointerException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_OUT_OF_BOUNDS_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedOutOfBoundsException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_CLASS_CAST_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedClassCastException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_ARRAY_STORE_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedArrayStoreException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor THROW_CACHED_ARITHMETIC_EXCEPTION = SnippetRuntime.findForeignCall(ImplicitExceptions.class, "throwCachedArithmeticException", true, new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{CREATE_NULL_POINTER_EXCEPTION, CREATE_OUT_OF_BOUNDS_EXCEPTION, CREATE_CLASS_CAST_EXCEPTION, CREATE_ARRAY_STORE_EXCEPTION, CREATE_DIVISION_BY_ZERO_EXCEPTION, THROW_NEW_NULL_POINTER_EXCEPTION, THROW_NEW_OUT_OF_BOUNDS_EXCEPTION, THROW_NEW_CLASS_CAST_EXCEPTION, THROW_NEW_ARRAY_STORE_EXCEPTION, THROW_NEW_ARITHMETIC_EXCEPTION, THROW_NEW_OUT_OF_BOUNDS_EXCEPTION_WITH_ARGS, THROW_NEW_CLASS_CAST_EXCEPTION_WITH_ARGS, THROW_NEW_ARRAY_STORE_EXCEPTION_WITH_ARGS, THROW_NEW_DIVISION_BY_ZERO_EXCEPTION, GET_CACHED_NULL_POINTER_EXCEPTION, GET_CACHED_OUT_OF_BOUNDS_EXCEPTION, GET_CACHED_CLASS_CAST_EXCEPTION, GET_CACHED_ARRAY_STORE_EXCEPTION, GET_CACHED_ARITHMETIC_EXCEPTION, THROW_CACHED_NULL_POINTER_EXCEPTION, THROW_CACHED_OUT_OF_BOUNDS_EXCEPTION, THROW_CACHED_CLASS_CAST_EXCEPTION, THROW_CACHED_ARRAY_STORE_EXCEPTION, THROW_CACHED_ARITHMETIC_EXCEPTION};
    private static final FastThreadLocalInt implicitExceptionsAreFatal = FastThreadLocalFactory.createInt();

    public static void activateImplicitExceptionsAreFatal() {
        implicitExceptionsAreFatal.set(implicitExceptionsAreFatal.get() + 1);
    }

    public static void deactivateImplicitExceptionsAreFatal() {
        implicitExceptionsAreFatal.set(implicitExceptionsAreFatal.get() - 1);
    }

    private static void vmErrorIfImplicitExceptionsAreFatal() {
        if (implicitExceptionsAreFatal.get() > 0 || SnippetRuntime.exceptionsAreFatal()) {
            throw VMError.shouldNotReachHere("Implicit exception thrown in code where such exceptions are fatal errors");
        }
    }

    @SubstrateForeignCallTarget
    private static NullPointerException createNullPointerException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return new NullPointerException();
    }

    @SubstrateForeignCallTarget
    private static ArrayIndexOutOfBoundsException createOutOfBoundsException(int index, int length) {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return new ArrayIndexOutOfBoundsException("Index " + index + " out of bounds for length " + length);
    }

    @SubstrateForeignCallTarget
    private static ClassCastException createClassCastException(Object object, Class<?> expectedClass) {
        assert (object != null) : "null can be cast to any type, so it cannot show up as a source of a ClassCastException";
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return new ClassCastException(object.getClass().getTypeName() + " cannot be cast to " + expectedClass.getTypeName());
    }

    @SubstrateForeignCallTarget
    private static ArrayStoreException createArrayStoreException(Object value) {
        assert (value != null) : "null can be stored into any array, so it cannot show up as a source of an ArrayStoreException";
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return new ArrayStoreException(value.getClass().getTypeName());
    }

    @SubstrateForeignCallTarget
    private static ArithmeticException createDivisionByZeroException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return new ArithmeticException("/ by zero");
    }

    @SubstrateForeignCallTarget
    private static void throwNewNullPointerException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new NullPointerException();
    }

    @SubstrateForeignCallTarget
    private static void throwNewOutOfBoundsException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new ArrayIndexOutOfBoundsException();
    }

    @SubstrateForeignCallTarget
    private static void throwNewOutOfBoundsExceptionWithArgs(int index, int length) {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new ArrayIndexOutOfBoundsException("Index " + index + " out of bounds for length " + length);
    }

    @SubstrateForeignCallTarget
    private static void throwNewClassCastException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new ClassCastException();
    }

    @SubstrateForeignCallTarget
    private static void throwNewClassCastExceptionWithArgs(Object object, Class<?> expectedClass) {
        assert (object != null) : "null can be cast to any type, so it cannot show up as a source of a ClassCastException";
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new ClassCastException(object.getClass().getTypeName() + " cannot be cast to " + expectedClass.getTypeName());
    }

    @SubstrateForeignCallTarget
    private static void throwNewArrayStoreException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new ArrayStoreException();
    }

    @SubstrateForeignCallTarget
    private static void throwNewArrayStoreExceptionWithArgs(Object value) {
        assert (value != null) : "null can be stored into any array, so it cannot show up as a source of an ArrayStoreException";
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new ArrayStoreException(value.getClass().getTypeName());
    }

    @SubstrateForeignCallTarget
    private static void throwNewArithmeticException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new ArithmeticException();
    }

    @SubstrateForeignCallTarget
    private static void throwNewDivisionByZeroException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw new ArithmeticException("/ by zero");
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implict exception in code that must not allocate.")
    @SubstrateForeignCallTarget
    private static NullPointerException getCachedNullPointerException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return CACHED_NULL_POINTER_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implict exception in code that must not allocate.")
    @SubstrateForeignCallTarget
    private static ArrayIndexOutOfBoundsException getCachedOutOfBoundsException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return CACHED_OUT_OF_BOUNDS_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implict exception in code that must not allocate.")
    @SubstrateForeignCallTarget
    private static ClassCastException getCachedClassCastException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return CACHED_CLASS_CAST_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implict exception in code that must not allocate.")
    @SubstrateForeignCallTarget
    private static ArrayStoreException getCachedArrayStoreException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return CACHED_ARRAY_STORE_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implict exception in code that must not allocate.")
    @SubstrateForeignCallTarget
    private static ArithmeticException getCachedArithmeticException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        return CACHED_ARITHMETIC_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implict exception in code that must not allocate.")
    @SubstrateForeignCallTarget
    private static void throwCachedNullPointerException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw CACHED_NULL_POINTER_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implict exception in code that must not allocate.")
    @SubstrateForeignCallTarget
    private static void throwCachedOutOfBoundsException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw CACHED_OUT_OF_BOUNDS_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implict exception in code that must not allocate.")
    @SubstrateForeignCallTarget
    private static void throwCachedClassCastException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw CACHED_CLASS_CAST_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implict exception in code that must not allocate.")
    @SubstrateForeignCallTarget
    private static void throwCachedArrayStoreException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw CACHED_ARRAY_STORE_EXCEPTION;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called to report an implict exception in code that must not allocate.")
    @SubstrateForeignCallTarget
    private static void throwCachedArithmeticException() {
        ImplicitExceptions.vmErrorIfImplicitExceptionsAreFatal();
        throw CACHED_ARITHMETIC_EXCEPTION;
    }

    public static void throwClassNotFoundException(String message) throws ClassNotFoundException {
        throw new ClassNotFoundException(message);
    }

    public static void throwNoSuchFieldException(String message) throws NoSuchFieldException {
        throw new NoSuchFieldException(message);
    }

    public static void throwNoSuchMethodException(String message) throws NoSuchMethodException {
        throw new NoSuchMethodException(message);
    }

    public static void throwNoClassDefFoundError(String message) throws NoClassDefFoundError {
        throw new NoClassDefFoundError(message);
    }

    public static void throwNoSuchFieldError(String message) throws NoSuchFieldError {
        throw new NoSuchFieldError(message);
    }

    public static void throwNoSuchMethodError(String message) throws NoSuchMethodError {
        throw new NoSuchMethodError(message);
    }

    public static void throwVerifyError() {
        throw new VerifyError();
    }
}

