/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Util_sun_net_sdp_SdpSupport;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.Unistd;
import java.io.IOException;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.PointerBase;
import sun.net.sdp.SdpSupport;

@TargetClass(value=SdpSupport.class)
@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
final class Target_sun_net_sdp_SdpSupport {
    private Target_sun_net_sdp_SdpSupport() {
    }

    @Substitute
    static void convert0(int fd) throws IOException {
        int s = Util_sun_net_sdp_SdpSupport.create();
        if (s >= 0) {
            int res;
            CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            CIntPointer arg_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            Socket.linger linger2 = (Socket.linger)StackValue.get(Socket.linger.class);
            len_Pointer.write(SizeOf.get(CIntPointer.class));
            if (Socket.getsockopt(fd, Socket.SOL_SOCKET(), Socket.SO_REUSEADDR(), (PointerBase)arg_Pointer, len_Pointer) == 0) {
                Socket.setsockopt(s, Socket.SOL_SOCKET(), Socket.SO_REUSEADDR(), (PointerBase)arg_Pointer, len_Pointer.read());
            }
            len_Pointer.write(SizeOf.get(CIntPointer.class));
            if (Socket.getsockopt(fd, Socket.SOL_SOCKET(), Socket.SO_OOBINLINE(), (PointerBase)arg_Pointer, len_Pointer) == 0) {
                Socket.setsockopt(s, Socket.SOL_SOCKET(), Socket.SO_OOBINLINE(), (PointerBase)arg_Pointer, len_Pointer.read());
            }
            len_Pointer.write(SizeOf.get(Socket.linger.class));
            if (Socket.getsockopt(fd, Socket.SOL_SOCKET(), Socket.SO_LINGER(), linger2, len_Pointer) == 0) {
                Socket.setsockopt(s, Socket.SOL_SOCKET(), Socket.SO_LINGER(), linger2, len_Pointer.read());
            }
            while ((res = Unistd.dup2(s, fd)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
            if (res < 0) {
                throw PosixUtils.newIOExceptionWithLastError("dup2");
            }
            while ((res = Unistd.close(fd)) == -1 && Errno.errno() == Errno.EINTR()) {
            }
        }
    }
}

