/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Poll;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.headers.Unistd;
import java.io.IOException;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
public final class PosixSunNioSubstitutions {

    static class Util_sun_nio_ch_PollArrayWrapper {
        Util_sun_nio_ch_PollArrayWrapper() {
        }

        static int ipoll(Poll.pollfd fds, int nfds, int timeout) {
            int res;
            int remaining = timeout;
            Time.timeval t = (Time.timeval)StackValue.get(Time.timeval.class);
            Time.gettimeofday(t, (Time.timezone)WordFactory.nullPointer());
            long start = t.tv_sec() * 1000L + t.tv_usec() / 1000L;
            while ((res = Poll.poll(fds, nfds, remaining)) < 0 && Errno.errno() == Errno.EINTR()) {
                if (remaining < 0) continue;
                Time.gettimeofday(t, (Time.timezone)WordFactory.nullPointer());
                long now = t.tv_sec() * 1000L + t.tv_usec() / 1000L;
                long diff = now - start;
                remaining = (int)((long)remaining - diff);
                if (diff < 0L || remaining <= 0) {
                    return 0;
                }
                start = now;
            }
            return res;
        }
    }

    @Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
    @TargetClass(className="sun.nio.ch.PollArrayWrapper", onlyWith={JDK8OrEarlier.class})
    static final class Target_sun_nio_ch_PollArrayWrapper {
        Target_sun_nio_ch_PollArrayWrapper() {
        }

        @Substitute
        int poll0(long address, int numfds, long timeout) throws IOException {
            int err = 0;
            Poll.pollfd a = (Poll.pollfd)WordFactory.pointer((long)address);
            if (timeout <= 0L) {
                while ((err = Poll.poll(a, numfds, (int)timeout)) == -1 && Errno.errno() == Errno.EINTR()) {
                }
            } else {
                err = Util_sun_nio_ch_PollArrayWrapper.ipoll(a, numfds, (int)timeout);
            }
            if (err < 0) {
                throw PosixUtils.newIOExceptionWithLastError("Poll failed");
            }
            return err;
        }

        @Substitute
        static void interrupt(int fd) throws IOException {
            CIntPointer fakebuf = (CIntPointer)StackValue.get((int)1, CIntPointer.class);
            fakebuf.write(0, 1);
            if (Unistd.write(fd, (PointerBase)fakebuf, WordFactory.unsigned((int)1)).lessThan(0)) {
                throw PosixUtils.newIOExceptionWithLastError("Write to interrupt fd failed");
            }
        }
    }
}

