/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.stack.JavaStackFrameVisitor;

class GetCallerClassVisitor
extends JavaStackFrameVisitor {
    private int depth;
    private boolean foundCallee;
    Class<?> result;

    GetCallerClassVisitor(int depth) {
        this.depth = depth;
    }

    @Override
    public boolean visitFrame(FrameInfoQueryResult frameInfo) {
        if (!this.foundCallee) {
            this.foundCallee = true;
            return true;
        }
        if (!StackTraceUtils.shouldShowFrame(frameInfo, false, false)) {
            return true;
        }
        if (this.depth > 0) {
            --this.depth;
            return true;
        }
        this.result = frameInfo.getSourceClass();
        return false;
    }
}

