/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.hub.DynamicHub;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class ClassForNameSupport {
    private final Map<String, Class<?>> knownClasses = new HashMap();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerClass(Class<?> clazz) {
        ((ClassForNameSupport)ImageSingletons.lookup(ClassForNameSupport.class)).knownClasses.put(clazz.getName(), clazz);
    }

    public static Class<?> forNameOrNull(String className, boolean initialize) {
        Class<?> result = ((ClassForNameSupport)ImageSingletons.lookup(ClassForNameSupport.class)).knownClasses.get(className);
        if (result == null) {
            return null;
        }
        if (initialize) {
            DynamicHub.fromClass(result).ensureInitialized();
        }
        return result;
    }

    public static Class<?> forName(String className, boolean initialize) throws ClassNotFoundException {
        Class<?> result = ClassForNameSupport.forNameOrNull(className, initialize);
        if (result == null) {
            throw new ClassNotFoundException(className);
        }
        return result;
    }
}

