/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.VMError;

public class NoAllocationVerifier
implements AutoCloseable {
    public static final String ERROR_MSG = "Attempt to allocate while allocation was explicitly disabled using a NoAllocationVerifier";
    private static final FastThreadLocalObject<NoAllocationVerifier> openVerifiers = FastThreadLocalFactory.createObject(NoAllocationVerifier.class);
    private String reason;
    private boolean isOpen;
    private NoAllocationVerifier next;

    public static void exit(String callSite, String typeName) {
        Log.log().string("[NoAllocationVerifier detected disallowed allocation: ").string(callSite).string(": ").string(typeName).newline();
        if (openVerifiers.get() != null) {
            Log.log().string("[NoAllocationVerifier stack: ");
            NoAllocationVerifier rest = openVerifiers.get();
            while (rest != null) {
                Log.log().newline().string("  ").string("  reason: ").string(rest.reason).newline();
                rest = rest.next;
            }
            Log.log().string("]").newline();
        }
        Log.log().string("]").newline();
        throw VMError.shouldNotReachHere(ERROR_MSG);
    }

    public static NoAllocationVerifier factory(String reason) {
        return NoAllocationVerifier.factory(reason, true);
    }

    public static NoAllocationVerifier factory(String reason, boolean open) {
        NoAllocationVerifier result = new NoAllocationVerifier(reason);
        if (open) {
            result.open();
        }
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isActive() {
        return openVerifiers.get() != null;
    }

    protected NoAllocationVerifier(String reason) {
        this.reason = reason;
        this.isOpen = false;
        this.next = null;
    }

    @NeverInline(value="Access of fields also used by allocation fast path, so must not be inlined in a method that performs allocation")
    public NoAllocationVerifier open() {
        VMError.guarantee(!this.isOpen, "NoAllocationVerifier already open");
        if (!NoAllocationVerifier.isActive()) {
            Heap.getHeap().suspendAllocation();
        }
        this.isOpen = true;
        this.next = openVerifiers.get();
        openVerifiers.set(this);
        return this;
    }

    @Override
    @NeverInline(value="Access of fields also used by allocation fast path, so must not be inlined in a method that performs allocation")
    public void close() {
        VMError.guarantee(this.isOpen, "NoAllocationVerifier not open");
        openVerifiers.set(this.next);
        this.next = null;
        this.isOpen = false;
        if (!NoAllocationVerifier.isActive()) {
            Heap.getHeap().resumeAllocation();
        }
    }
}

