/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.StringTable;
import com.oracle.objectfile.debugentry.TypeEntry;
import org.graalvm.compiler.debug.DebugContext;

public class Range {
    private static final String CLASS_DELIMITER = ".";
    private Range caller;
    private final MethodEntry methodEntry;
    private final String fullMethodName;
    private final String fullMethodNameWithParams;
    private final int lo;
    private int hi;
    private final int line;
    private final boolean isInlined;
    private final int depth;
    private final Range primary;
    private Range firstCallee;
    private Range lastCallee;
    private Range siblingCallee;

    public Range(StringTable stringTable, MethodEntry methodEntry, int lo, int hi, int line) {
        this(stringTable, methodEntry, lo, hi, line, null, false, null);
    }

    public Range(StringTable stringTable, MethodEntry methodEntry, int lo, int hi, int line, Range primary, boolean isInline, Range caller) {
        assert (methodEntry != null);
        if (methodEntry.fileEntry != null) {
            stringTable.uniqueDebugString(methodEntry.fileEntry.getFileName());
            stringTable.uniqueDebugString(methodEntry.fileEntry.getPathName());
        }
        this.methodEntry = methodEntry;
        this.fullMethodName = isInline ? stringTable.uniqueDebugString(this.constructClassAndMethodName()) : stringTable.uniqueString(this.constructClassAndMethodName());
        this.fullMethodNameWithParams = this.constructClassAndMethodNameWithParams();
        this.lo = lo;
        this.hi = hi;
        this.line = line;
        this.isInlined = isInline;
        this.primary = primary;
        this.firstCallee = null;
        this.lastCallee = null;
        this.siblingCallee = null;
        this.caller = caller;
        if (caller != null) {
            caller.addCallee(this);
        }
        this.depth = this.isPrimary() ? -1 : caller.depth + 1;
    }

    private void addCallee(Range callee) {
        assert (this.lo <= callee.lo);
        assert (this.hi >= callee.hi);
        assert (callee.caller == this);
        assert (callee.siblingCallee == null);
        if (this.firstCallee == null) {
            assert (this.lastCallee == null);
            this.firstCallee = this.lastCallee = callee;
        } else {
            this.lastCallee.siblingCallee = callee;
            this.lastCallee = callee;
        }
    }

    public boolean contains(Range other) {
        return this.lo <= other.lo && this.hi >= other.hi;
    }

    public boolean isPrimary() {
        return this.getPrimary() == null;
    }

    public Range getPrimary() {
        return this.primary;
    }

    public String getClassName() {
        return this.methodEntry.ownerType.typeName;
    }

    public String getMethodName() {
        return this.methodEntry.memberName;
    }

    public String getSymbolName() {
        return this.methodEntry.getSymbolName();
    }

    public int getHi() {
        return this.hi;
    }

    public int getLo() {
        return this.lo;
    }

    public int getLine() {
        return this.line;
    }

    public String getFullMethodName() {
        return this.fullMethodName;
    }

    public String getFullMethodNameWithParams() {
        return this.fullMethodNameWithParams;
    }

    public boolean isDeoptTarget() {
        return this.methodEntry.isDeopt();
    }

    private String getExtendedMethodName(boolean includeClass, boolean includeParams, boolean includeReturnType) {
        StringBuilder builder = new StringBuilder();
        if (includeReturnType && this.methodEntry.valueType.typeName.length() > 0) {
            builder.append(this.methodEntry.valueType.typeName);
            builder.append(' ');
        }
        if (includeClass && this.getClassName() != null) {
            builder.append(this.getClassName());
            builder.append(CLASS_DELIMITER);
        }
        builder.append(this.getMethodName());
        if (includeParams) {
            builder.append("(");
            String prefix = "";
            for (TypeEntry t : this.methodEntry.paramTypes) {
                builder.append(prefix);
                builder.append(t.getTypeName());
                prefix = ", ";
            }
            builder.append(')');
        }
        if (includeReturnType) {
            builder.append(" ");
            builder.append(this.methodEntry.valueType.typeName);
        }
        return builder.toString();
    }

    private String constructClassAndMethodName() {
        return this.getExtendedMethodName(true, false, false);
    }

    private String constructClassAndMethodNameWithParams() {
        return this.getExtendedMethodName(true, true, false);
    }

    public FileEntry getFileEntry() {
        return this.methodEntry.fileEntry;
    }

    public int getModifiers() {
        return this.methodEntry.modifiers;
    }

    public String toString() {
        return String.format("Range(lo=0x%05x hi=0x%05x %s %s:%d)", this.lo, this.hi, this.constructClassAndMethodNameWithParams(), this.methodEntry.getFullFileName(), this.line);
    }

    public String getFileName() {
        return this.methodEntry.getFileName();
    }

    public MethodEntry getMethodEntry() {
        return this.methodEntry;
    }

    public boolean isInlined() {
        return this.isInlined;
    }

    public Range getCaller() {
        return this.caller;
    }

    public Range getFirstCallee() {
        return this.firstCallee;
    }

    public Range getSiblingCallee() {
        return this.siblingCallee;
    }

    public Range getLastCallee() {
        return this.lastCallee;
    }

    public boolean isLeaf() {
        return this.firstCallee == null;
    }

    public int getDepth() {
        return this.depth;
    }

    public void mergeSubranges(DebugContext debugContext) {
        Range next = this.getFirstCallee();
        if (next == null) {
            return;
        }
        debugContext.log(2, "Merge subranges [0x%x, 0x%x] %s", (Object)this.lo, (Object)this.hi, (Object)this.getFullMethodNameWithParams());
        while (next != null) {
            next = next.maybeMergeSibling(debugContext);
        }
        for (next = this.getFirstCallee(); next != null; next = next.getSiblingCallee()) {
            next.mergeSubranges(debugContext);
        }
    }

    private Range maybeMergeSibling(DebugContext debugContext) {
        Range sibling = this.getSiblingCallee();
        debugContext.log(2, "Merge subrange (maybe) [0x%x, 0x%x] %s", (Object)this.lo, (Object)this.hi, (Object)this.getFullMethodNameWithParams());
        if (sibling == null) {
            return null;
        }
        if (this.hi < sibling.lo) {
            return sibling;
        }
        if (this.getMethodEntry() != sibling.getMethodEntry()) {
            return sibling;
        }
        if (this.getLine() != sibling.getLine()) {
            return sibling;
        }
        if (this.isLeaf() != sibling.isLeaf()) {
            return sibling;
        }
        this.unlink(debugContext, sibling);
        this.reparentChildren(debugContext, sibling);
        return this;
    }

    private void unlink(DebugContext debugContext, Range sibling) {
        assert (this.hi == sibling.lo) : String.format("gap in range [0x%x,0x%x] %s [0x%x,0x%x] %s", this.lo, this.hi, this.getFullMethodNameWithParams(), sibling.getLo(), sibling.getHi(), sibling.getFullMethodNameWithParams());
        assert (this.isInlined == sibling.isInlined) : String.format("change in inlined [0x%x,0x%x] %s %s [0x%x,0x%x] %s %s", this.lo, this.hi, this.getFullMethodNameWithParams(), this.isInlined, sibling.lo, sibling.hi, sibling.getFullMethodNameWithParams(), sibling.isInlined);
        debugContext.log(2, "Combining [0x%x, 0x%x] %s into [0x%x, 0x%x] %s", (Object)sibling.lo, (Object)sibling.hi, (Object)sibling.getFullMethodName(), (Object)this.lo, (Object)this.hi, (Object)this.getFullMethodNameWithParams());
        this.hi = sibling.hi;
        this.siblingCallee = sibling.siblingCallee;
    }

    private void reparentChildren(DebugContext debugContext, Range sibling) {
        Range siblingNext = sibling.getFirstCallee();
        while (siblingNext != null) {
            debugContext.log(2, "Reparenting [0x%x, 0x%x] %s to [0x%x, 0x%x] %s", (Object)siblingNext.lo, (Object)siblingNext.hi, (Object)siblingNext.getFullMethodName(), (Object)this.lo, (Object)this.hi, (Object)this.getFullMethodNameWithParams());
            siblingNext.caller = this;
            Range newSiblingNext = siblingNext.siblingCallee;
            siblingNext.siblingCallee = null;
            this.addCallee(siblingNext);
            siblingNext = newSiblingNext;
        }
    }
}

