/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven.config;

import java.io.File;
import java.nio.file.Path;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.logging.Logger;
import org.graalvm.buildtools.utils.NativeImageConfigurationUtils;
import org.graalvm.buildtools.utils.NativeImageUtils;

public abstract class AbstractMergeAgentFilesMojo
extends AbstractMojo {
    @Component
    protected Logger logger;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Component
    protected ToolchainManager toolchainManager;
    @Parameter(property="enforceToolchain")
    protected boolean enforceToolchain;
    private File mergerExecutable;

    public File getMergerExecutable() throws MojoExecutionException {
        if (this.mergerExecutable == null) {
            this.initializeMergerExecutable();
        }
        return this.mergerExecutable;
    }

    private void initializeMergerExecutable() throws MojoExecutionException {
        Path nativeImage = NativeImageConfigurationUtils.getNativeImageSupportingToolchain(this.logger, this.toolchainManager, this.session, this.enforceToolchain);
        File nativeImageExecutable = nativeImage.toAbsolutePath().toFile();
        String nativeImageConfigureFileName = NativeImageUtils.nativeImageConfigureFileName();
        File mergerExecutable = new File(nativeImageExecutable.getParentFile(), nativeImageConfigureFileName);
        if (!mergerExecutable.exists()) {
            throw new MojoExecutionException("The '" + nativeImageConfigureFileName + "' tool was not found in the GraalVM JDK at '" + String.valueOf(nativeImageExecutable.getParentFile().getParentFile()) + "'.This probably means that you are using a GraalVM distribution that is not fully supported by the Native Build Tools. Please try again, for example, with Oracle GraalVM or GraalVM Community Edition.");
        }
        this.mergerExecutable = mergerExecutable;
    }
}

