/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.graalvm.buildtools.maven.AbstractNativeImageMojo;
import org.graalvm.buildtools.maven.sbom.SBOMGenerator;
import org.graalvm.buildtools.utils.NativeImageUtils;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="compile-no-fork", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, requiresDependencyCollection=ResolutionScope.RUNTIME)
public class NativeCompileNoForkMojo
extends AbstractNativeImageMojo {
    @Parameter(property="skipNativeBuild", defaultValue="false")
    private boolean skip;
    @Parameter(property="skipNativeBuildForPom", defaultValue="false")
    private boolean skipNativeBuildForPom;
    @Parameter(property="skipBaseSBOM", defaultValue="false")
    private boolean skipBaseSBOM;
    public static final String SKIP_BASE_SBOM_PARAM_NAME = "skipBaseSBOM";
    private PluginParameterExpressionEvaluator evaluator;

    @Override
    protected List<String> getDependencyScopes() {
        return Arrays.asList("compile", "runtime", "compile+runtime");
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.logger.info("Skipping native-image generation (parameter 'skipNativeBuild' is true).");
            return;
        }
        if (this.skipNativeBuildForPom && this.project.getPackaging().equals("pom")) {
            this.logger.info("Skipping native-image generation (parameter 'skipNativeBuildForPom' is true).");
            return;
        }
        this.evaluator = new PluginParameterExpressionEvaluator(this.session, this.mojoExecution);
        this.maybeSetMainClassFromPlugin(this::consumeExecutionsNodeValue, "org.apache.maven.plugins:maven-shade-plugin", "transformers", "transformer", "mainClass");
        this.maybeSetMainClassFromPlugin(this::consumeConfigurationNodeValue, "org.apache.maven.plugins:maven-assembly-plugin", "archive", "manifest", "mainClass");
        this.maybeSetMainClassFromPlugin(this::consumeConfigurationNodeValue, "org.apache.maven.plugins:maven-jar-plugin", "archive", "manifest", "mainClass");
        this.maybeAddGeneratedResourcesConfig(this.buildArgs);
        this.generateDynamicAccessMetadataIfNeeded(this.buildArgs);
        this.generateBaseSBOMIfNeeded();
        this.buildImage();
    }

    private void generateDynamicAccessMetadataIfNeeded(List<String> buildArgs) throws MojoExecutionException {
        if (buildArgs.stream().anyMatch(arg -> arg.startsWith("--emit build-report"))) {
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)this.project.getPlugin("org.graalvm.buildtools:native-maven-plugin").getGroupId()), (String)MojoExecutor.artifactId((String)this.project.getPlugin("org.graalvm.buildtools:native-maven-plugin").getArtifactId()), (String)MojoExecutor.version((String)this.project.getPlugin("org.graalvm.buildtools:native-maven-plugin").getVersion())), (String)MojoExecutor.goal((String)"generateDynamicAccessMetadata"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"outputJson", (String)"${project.build.directory}/dynamic-access-metadata.json")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        }
    }

    private void generateBaseSBOMIfNeeded() throws MojoExecutionException {
        if (this.skipBaseSBOM) {
            this.logger.info(String.format("Skipping base SBOM generation (parameter '%s' is true).", SKIP_BASE_SBOM_PARAM_NAME));
            return;
        }
        SBOMGenerator sbomGenerator = new SBOMGenerator(this.mavenProject, this.mavenSession, this.pluginManager, this.repositorySystem, this.mainClass);
        SBOMGenerator.Config config = new SBOMGenerator.Config(NativeCompileNoForkMojo.isOracleGraalVM(this.logger), this.getBuildArgs(), NativeImageUtils.getMajorJDKVersion((String)NativeCompileNoForkMojo.getVersionInformation(this.logger)));
        try {
            sbomGenerator.generateIfSupportedAndEnabled(config);
        }
        catch (Throwable e) {
            this.logger.warn(String.format("Could not generate base SBOM: %s. Fallback to generating an SBOM without knowledge from 'native-build-tools'.", e.getCause().getMessage()));
        }
    }

    private String consumeConfigurationNodeValue(String pluginKey, String ... nodeNames) {
        Plugin selectedPlugin = this.project.getPlugin(pluginKey);
        if (selectedPlugin == null) {
            return null;
        }
        return this.getConfigurationNodeValue((ConfigurationContainer)selectedPlugin, nodeNames);
    }

    private String consumeExecutionsNodeValue(String pluginKey, String ... nodeNames) {
        Plugin selectedPlugin = this.project.getPlugin(pluginKey);
        if (selectedPlugin == null) {
            return null;
        }
        for (PluginExecution execution : selectedPlugin.getExecutions()) {
            String value = this.getConfigurationNodeValue((ConfigurationContainer)execution, nodeNames);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private String getConfigurationNodeValue(ConfigurationContainer container, String ... nodeNames) {
        if (container != null && container.getConfiguration() instanceof Xpp3Dom) {
            Xpp3Dom node = (Xpp3Dom)container.getConfiguration();
            for (String nodeName : nodeNames) {
                if ((node = node.getChild(nodeName)) != null) continue;
                return null;
            }
            String value = node.getValue();
            return this.evaluateValue(value);
        }
        return null;
    }

    private String evaluateValue(String value) {
        if (value != null) {
            try {
                Object evaluatedValue = this.evaluator.evaluate(value);
                if (evaluatedValue instanceof String) {
                    return (String)evaluatedValue;
                }
            }
            catch (ExpressionEvaluationException expressionEvaluationException) {
                // empty catch block
            }
        }
        return null;
    }

    private void maybeSetMainClassFromPlugin(BiFunction<String, String[], String> mainClassProvider, String pluginName, String ... nodeNames) {
        if (this.mainClass == null) {
            this.mainClass = mainClassProvider.apply(pluginName, nodeNames);
            if (this.mainClass != null) {
                this.logger.info("Obtained main class from plugin " + pluginName + " with the following path: " + String.join((CharSequence)" -> ", nodeNames));
            }
        }
    }
}

