/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.spec;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.glassfish.spec.Artifact;
import org.glassfish.spec.Metadata;

public class Spec {
    public static final String JAVAX_GROUP_ID = "javax.";
    public static final String JAKARTA_GROUP_ID = "jakarta.";
    private Artifact artifact;
    private Metadata metadata;
    private JarFile jar;
    private String specVersion = null;
    private String newSpecVersion;
    private String specImplVersion;
    private String implVersion;
    private String newImplVersion;
    private String specBuild;
    private String implBuild;
    private String apiPackage = null;
    private String implNamespace;
    private String groupIdPrefix;
    private boolean nonFinal = false;
    private JarType jarType = JarType.api;
    private final List<String> errors = new LinkedList<String>();
    private static final String NONFINAL_BUILD_SEPARATOR_SPEC = ".99.";
    private static final String NONFINAL_BUILD_SEPARATOR = ".99.b";
    private static final String JCP_VERSION_RULE = "JCP spec version number must be of the form <major>.<minor>";
    public static final String API_SUFFIX = "-api";

    public void read(JarFile jarfile) throws IOException {
        this.jar = jarfile;
        this.artifact = Artifact.fromJar(this.jar);
        this.metadata = Metadata.fromJar(this.jar);
        this.errors.clear();
        this.errors.addAll(this.metadata.getErrors());
    }

    private void checkClasses(JarFile jarfile, String ... pkgs) {
        Enumeration<JarEntry> e = jarfile.entries();
        HashSet<String> badPackages = new HashSet<String>();
        block0: while (e.hasMoreElements()) {
            String name;
            JarEntry je = e.nextElement();
            if (je.isDirectory() || !(name = je.getName()).endsWith(".class")) continue;
            name = name.substring(0, name.length() - 6);
            name = name.replace('/', '.');
            for (String p : pkgs) {
                if (name.startsWith(p) && name.charAt(p.length()) == '.') continue block0;
            }
            int i = name.lastIndexOf(46);
            if (i > 0) {
                name = name.substring(0, i);
            }
            if (badPackages.contains(name)) continue;
            badPackages.add(name);
            if (!name.startsWith(this.groupIdPrefix)) continue;
            this.errors.add(String.format("ERROR: jar file includes class in wrong package (%s)", name));
        }
    }

    public void verify() {
        String symbolicName;
        this.errors.clear();
        this.errors.addAll(this.getMetadata().getErrors());
        StringBuilder configIssues = new StringBuilder();
        if (this.specVersion == null || this.specVersion.isEmpty()) {
            configIssues.append(" spec-version");
        }
        if (this.apiPackage == null || this.apiPackage.isEmpty()) {
            configIssues.append(" api-package");
        }
        if (this.nonFinal && (this.newSpecVersion == null || this.newSpecVersion.isEmpty())) {
            configIssues.append(" new-spec-version");
        }
        if (this.jarType.equals((Object)JarType.impl)) {
            if (this.implNamespace == null || this.implNamespace.isEmpty()) {
                configIssues.append(" impl-namespace");
            }
            if (this.implVersion == null || this.implVersion.isEmpty()) {
                configIssues.append(" impl-version");
            }
            if (this.nonFinal && (this.newImplVersion == null || this.newImplVersion.isEmpty())) {
                configIssues.append(" new-impl-version");
            }
        } else if (!this.nonFinal && (this.specImplVersion == null || this.specImplVersion.isEmpty())) {
            configIssues.append(" spec-impl-version");
        }
        if (configIssues.length() > 0) {
            configIssues.insert(0, "ERROR: missing configuration (");
            configIssues.append(" )");
            this.errors.add(configIssues.toString());
            return;
        }
        if (!this.specVersion.matches("[0-9]+\\.[0-9]+")) {
            this.errors.add(String.format("WARNING: spec-version (%s) is invalid, %s", this.specVersion, JCP_VERSION_RULE));
        }
        if (!this.getMetadata().getjarImplementationVersion().isEmpty() && !this.getMetadata().getjarImplementationVersion().equals(this.artifact.getAbsoluteVersion())) {
            this.errors.add(String.format("WARNING: %s (%s) should be equal to Maven-Version (%s)", "Implementation-Version", this.getMetadata().getjarImplementationVersion(), this.artifact.getAbsoluteVersion()));
        }
        if (!this.getMetadata().getJarExtensionName().equals(this.apiPackage)) {
            this.errors.add(String.format("WARNING: %s (%s) should be %s", "Extension-Name", this.getMetadata().getJarExtensionName(), this.apiPackage));
        }
        if (!this.nonFinal) {
            if (!this.getMetadata().getBundleVersion().equals(this.artifact.getAbsoluteVersion())) {
                this.errors.add(String.format("WARNING: %s (%s) should be %s", "Bundle-Version", this.metadata.getBundleVersion(), this.artifact.getAbsoluteVersion()));
            }
            if (!this.getMetadata().getJarSpecificationVersion().equals(this.specVersion)) {
                this.errors.add(String.format("WARNING: %s (%s) should be %s", "Specification-Version", this.metadata.getJarSpecificationVersion(), this.specVersion));
            }
        } else {
            DefaultArtifactVersion av = new DefaultArtifactVersion(this.specVersion);
            String bundleVersion = av.getMajorVersion() + "." + av.getMinorVersion() + NONFINAL_BUILD_SEPARATOR + (this.jarType.equals((Object)JarType.impl) ? this.implBuild : this.specBuild);
            if (!this.getMetadata().getBundleVersion().equals(bundleVersion)) {
                this.errors.add(String.format("WARNING: %s (%s) should be %s", "Bundle-Version", this.metadata.getBundleVersion(), bundleVersion));
            }
            String expectedJarSpecVersion = this.specVersion + NONFINAL_BUILD_SEPARATOR_SPEC + this.specBuild;
            if (!this.getMetadata().getJarSpecificationVersion().equals(expectedJarSpecVersion)) {
                this.errors.add(String.format("WARNING: %s (%s) should be %s", "Specification-Version", this.metadata.getJarSpecificationVersion(), expectedJarSpecVersion));
            }
        }
        if (this.jarType.equals((Object)JarType.api)) {
            if (!this.artifact.getGroupId().startsWith(this.groupIdPrefix)) {
                this.errors.add(String.format("WARNING: groupId (%s) must start with \"%s\"", this.artifact.getGroupId(), this.groupIdPrefix));
            }
            if (!this.artifact.getArtifactId().endsWith(API_SUFFIX)) {
                this.errors.add(String.format("WARNING: artifactId (%s) should en with %s", this.artifact.getArtifactId(), API_SUFFIX));
            }
            if (!this.apiPackage.startsWith(JAVAX_GROUP_ID)) {
                this.errors.add(String.format("WARNING: API packages (%s) must start with \"%s\"", this.apiPackage, this.groupIdPrefix));
            }
            symbolicName = this.apiPackage.concat(API_SUFFIX);
            if (!this.getMetadata().getBundleSymbolicName().isEmpty() && !symbolicName.equals(this.getMetadata().getBundleSymbolicName())) {
                this.errors.add(String.format("WARNING: %s (%s) should be %s", "Bundle-SymbolicName", this.getMetadata().getBundleSymbolicName(), symbolicName));
            }
            if (this.jar != null) {
                this.checkClasses(this.jar, this.apiPackage);
            }
            if (this.nonFinal) {
                if (!this.newSpecVersion.matches("[0-9]+\\.[0-9]+")) {
                    this.errors.add(String.format("WARNING: new-spec-version (%s) is invalid, %s", this.newSpecVersion, JCP_VERSION_RULE));
                }
                if (this.specVersion.equals(this.newSpecVersion)) {
                    this.errors.add(String.format("WARNING: spec-version (%s) can't be equal to new-spec-version (%s) for non final artifacts", this.specVersion, this.newSpecVersion));
                } else {
                    DefaultArtifactVersion specAV = new DefaultArtifactVersion(this.specVersion);
                    DefaultArtifactVersion newSpecAV = new DefaultArtifactVersion(this.newSpecVersion);
                    if (specAV.compareTo((Object)newSpecAV) > 0) {
                        this.errors.add(String.format("WARNING: new-spec-version (%s) must be greater than spec-version (%s)", this.newSpecVersion, this.specVersion));
                    } else if (newSpecAV.getMajorVersion() - specAV.getMajorVersion() > 1 || newSpecAV.getMinorVersion() - specAV.getMinorVersion() > 1) {
                        this.errors.add(String.format("WARNING offset between new-spec-version (%s) and spec-version (%s) can't be greater than 1", this.newSpecVersion, this.specVersion));
                    }
                }
            } else if (!(this.specImplVersion.equals(this.specVersion) || this.specImplVersion.startsWith(this.specVersion + ".") || this.specImplVersion.startsWith(this.specVersion + "-"))) {
                this.errors.add(String.format("WARNING: spec-impl-version (%s) must start with JCP spec-version number (%s)", this.specImplVersion, this.specVersion));
            }
        } else {
            if (this.artifact.getGroupId().startsWith(this.groupIdPrefix)) {
                this.errors.add(String.format("WARNING: groupId (%s) should not start with \"%s\"", this.artifact.getGroupId(), this.groupIdPrefix));
            }
            if (this.artifact.getArtifactId().endsWith(API_SUFFIX)) {
                this.errors.add(String.format("WARNING: artifactId (%s) should not end with %s", this.artifact.getArtifactId(), API_SUFFIX));
            }
            if (!this.apiPackage.startsWith(this.groupIdPrefix)) {
                this.errors.add(String.format("WARNING: API packages (%s) must start with \"%s\"", this.apiPackage, this.groupIdPrefix));
            }
            symbolicName = this.implNamespace + '.' + this.apiPackage;
            if (!this.getMetadata().getBundleSymbolicName().equals(symbolicName)) {
                this.errors.add(String.format("WARNING: %s (%s) should be %s", "Bundle-SymbolicName", this.getMetadata().getBundleSymbolicName(), symbolicName));
            }
            if (this.jar != null) {
                this.checkClasses(this.jar, this.apiPackage, this.implNamespace);
            }
            if (this.nonFinal) {
                if (this.implVersion.equals(this.newImplVersion)) {
                    this.errors.add(String.format("WARNING: impl-version (%s) can't be equal to new-impl-version (%s) for non final artifacts", this.implVersion, this.newImplVersion));
                } else {
                    DefaultArtifactVersion implAV = new DefaultArtifactVersion(this.implVersion);
                    DefaultArtifactVersion newImplAV = new DefaultArtifactVersion(this.newImplVersion);
                    if (implAV.compareTo((Object)newImplAV) > 0) {
                        this.errors.add(String.format("WARNING: new-impl-version (%s) must be greater than impl-version (%s)", this.newImplVersion, this.implVersion));
                    } else if (newImplAV.getMajorVersion() - implAV.getMajorVersion() > 1 || newImplAV.getMinorVersion() - implAV.getMinorVersion() > 1) {
                        this.errors.add(String.format("WARNING: offset between new-impl-version (%s) and impl-version (%s) can't be greater than 1", this.newImplVersion, this.implVersion));
                    }
                }
            }
        }
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Metadata getMetadata() {
        if (this.metadata != null) {
            return this.metadata;
        }
        Objects.requireNonNull(this.specVersion, "specVersion is null");
        Objects.requireNonNull(this.apiPackage, "apiPackage is null");
        if (this.jarType.equals((Object)JarType.api)) {
            if (!this.nonFinal) {
                this.metadata = new Metadata(this.apiPackage + API_SUFFIX, this.specVersion, this.specImplVersion, this.apiPackage, this.specVersion, this.specImplVersion);
            } else {
                String osgiVersion = this.specVersion + NONFINAL_BUILD_SEPARATOR + this.specBuild;
                this.metadata = new Metadata(this.apiPackage + API_SUFFIX, osgiVersion, osgiVersion, this.apiPackage, this.specVersion + NONFINAL_BUILD_SEPARATOR_SPEC + this.specBuild, this.artifact.getAbsoluteVersion());
            }
        } else {
            String symbolicName = this.implNamespace + "." + this.apiPackage;
            if (!this.nonFinal) {
                this.metadata = new Metadata(symbolicName, this.specVersion, this.implVersion, this.apiPackage, this.specVersion, this.artifact.getAbsoluteVersion());
            } else {
                DefaultArtifactVersion implAv = new DefaultArtifactVersion(this.implVersion);
                this.metadata = new Metadata(symbolicName, this.specVersion + NONFINAL_BUILD_SEPARATOR + this.implBuild, implAv.getMajorVersion() + "." + implAv.getMinorVersion() + NONFINAL_BUILD_SEPARATOR + this.implBuild, this.apiPackage, this.specVersion + NONFINAL_BUILD_SEPARATOR_SPEC + this.implBuild, this.artifact.getAbsoluteVersion());
            }
        }
        return this.metadata;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setGroupIdPrefix(String prefix) {
        if (prefix != null && !prefix.isEmpty()) {
            this.groupIdPrefix = prefix;
        }
    }

    public void setApiPackage(String pkg) {
        if (pkg != null && !pkg.isEmpty()) {
            this.apiPackage = pkg;
        }
    }

    public void setImplNamespace(String namespace) {
        this.implNamespace = namespace != null ? namespace : "";
    }

    public void setImplVersion(String version) {
        this.implVersion = version != null ? Artifact.stripSnapshotQualifier(version) : "";
    }

    public void setSpecVersion(String version) {
        if (version != null && !version.isEmpty()) {
            this.specVersion = version;
        }
    }

    public void setNewImplVersion(String version) {
        this.newImplVersion = version != null ? version : "";
    }

    public void setSpecBuild(String build) {
        this.specBuild = build != null ? build : "";
    }

    public void setSpecImplVersion(String version) {
        this.specImplVersion = version != null ? Artifact.stripSnapshotQualifier(version) : "";
    }

    public void setNewSpecVersion(String version) {
        this.newSpecVersion = version != null ? version : "";
    }

    public void setImplBuild(String build) {
        this.implBuild = build != null ? build : "";
    }

    public void setArtifact(Artifact a) {
        this.artifact = a;
    }

    public void setNonFinal(boolean nfinal) {
        this.nonFinal = nfinal;
    }

    public void setJarType(String type) {
        this.jarType = JarType.valueOf(type);
    }

    public void setMetadata(Metadata mdata) {
        this.metadata = mdata;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.jarType == null) {
            return sb.toString();
        }
        sb.append("{");
        sb.append(" groupIdPrefix=");
        sb.append(this.groupIdPrefix);
        if (this.specVersion != null && !this.specVersion.isEmpty()) {
            sb.append(" spec-version=");
            sb.append(this.specVersion);
        }
        if (this.apiPackage != null && !this.apiPackage.isEmpty()) {
            sb.append(" apiPackage=");
            sb.append(this.apiPackage);
        }
        if (this.jarType.equals((Object)JarType.impl)) {
            sb.append(" standalone-impl");
            sb.append(" impl-namespace=");
            sb.append(this.implNamespace);
            if (this.nonFinal) {
                sb.append(" non-final");
                sb.append(" new-spec-version=");
                sb.append(this.newSpecVersion);
                sb.append(" new-impl-version=");
                sb.append(this.newSpecVersion);
                sb.append(" impl-build=");
                sb.append(this.implBuild);
            } else {
                sb.append(" final");
            }
            sb.append(" impl-version=");
            sb.append(this.implVersion);
        } else {
            sb.append(" API");
            if (this.nonFinal) {
                sb.append(" non-final");
                sb.append(" new-spec-version=");
                sb.append(this.newSpecVersion);
                sb.append(" spec-build=");
                sb.append(this.specBuild);
            } else {
                sb.append(" final");
                sb.append(" spec-impl-version=");
                sb.append(this.specImplVersion);
            }
        }
        sb.append(" }");
        return sb.toString();
    }

    public static enum JarType {
        api,
        impl;

    }
}

