/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerSQLXML;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.TemporalCompatibility;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import microsoft.sql.DateTimeOffset;

enum JavaType {
    INTEGER(Integer.class, JDBCType.INTEGER),
    STRING(String.class, JDBCType.CHAR),
    DATE(Date.class, JDBCType.DATE),
    TIME(Time.class, JDBCType.TIME),
    TIMESTAMP(Timestamp.class, JDBCType.TIMESTAMP),
    UTILDATE(java.util.Date.class, JDBCType.TIMESTAMP),
    CALENDAR(Calendar.class, JDBCType.TIMESTAMP),
    LOCALDATE(JavaType.getJavaClass("LocalDate"), JDBCType.DATE),
    LOCALTIME(JavaType.getJavaClass("LocalTime"), JDBCType.TIME),
    LOCALDATETIME(JavaType.getJavaClass("LocalDateTime"), JDBCType.TIMESTAMP),
    OFFSETTIME(JavaType.getJavaClass("OffsetTime"), JDBCType.TIME_WITH_TIMEZONE),
    OFFSETDATETIME(JavaType.getJavaClass("OffsetDateTime"), JDBCType.TIMESTAMP_WITH_TIMEZONE),
    DATETIMEOFFSET(DateTimeOffset.class, JDBCType.DATETIMEOFFSET),
    BOOLEAN(Boolean.class, JDBCType.BIT),
    BIGDECIMAL(BigDecimal.class, JDBCType.DECIMAL),
    DOUBLE(Double.class, JDBCType.DOUBLE),
    FLOAT(Float.class, JDBCType.REAL),
    SHORT(Short.class, JDBCType.SMALLINT),
    LONG(Long.class, JDBCType.BIGINT),
    BIGINTEGER(BigInteger.class, JDBCType.BIGINT),
    BYTE(Byte.class, JDBCType.TINYINT),
    BYTEARRAY(byte[].class, JDBCType.BINARY),
    NCLOB(NClob.class, JDBCType.NCLOB),
    CLOB(Clob.class, JDBCType.CLOB),
    BLOB(Blob.class, JDBCType.BLOB),
    INPUTSTREAM((Class)InputStream.class, JDBCType.UNKNOWN){

        @Override
        JDBCType getJDBCType(SSType sSType, JDBCType jDBCType) {
            JDBCType jDBCType2;
            if (SSType.UNKNOWN != sSType) {
                switch (sSType) {
                    case CHAR: 
                    case VARCHAR: 
                    case VARCHARMAX: 
                    case TEXT: 
                    case NCHAR: 
                    case NVARCHAR: 
                    case NVARCHARMAX: 
                    case NTEXT: {
                        jDBCType2 = JDBCType.LONGVARCHAR;
                        break;
                    }
                    default: {
                        jDBCType2 = JDBCType.LONGVARBINARY;
                        break;
                    }
                }
            } else {
                JDBCType jDBCType3 = jDBCType2 = jDBCType.isTextual() ? JDBCType.LONGVARCHAR : JDBCType.LONGVARBINARY;
            }
            assert (null != jDBCType2);
            return jDBCType2;
        }
    }
    ,
    READER(Reader.class, JDBCType.LONGVARCHAR),
    SQLXML(SQLServerSQLXML.class, JDBCType.SQLXML),
    OBJECT(Object.class, JDBCType.UNKNOWN);

    private final Class<?> javaClass;
    private final JDBCType jdbcTypeFromJavaType;
    private static double jvmVersion;

    private JavaType(Class<?> clazz, JDBCType jDBCType) {
        this.javaClass = clazz;
        this.jdbcTypeFromJavaType = jDBCType;
    }

    static Class<?> getJavaClass(String string) {
        if (0.0 == jvmVersion) {
            try {
                String string2 = System.getProperty("java.specification.version");
                if (string2 != null) {
                    jvmVersion = Double.parseDouble(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                jvmVersion = 0.1;
            }
        }
        if (jvmVersion < 1.8) {
            return TemporalCompatibility.class;
        }
        if (string.equals("LocalDate")) {
            return LocalDate.class;
        }
        if (string.equals("LocalTime")) {
            return LocalTime.class;
        }
        if (string.equals("LocalDateTime")) {
            return LocalDateTime.class;
        }
        if (string.equals("OffsetTime")) {
            return OffsetTime.class;
        }
        if (string.equals("OffsetDateTime")) {
            return OffsetDateTime.class;
        }
        return TemporalCompatibility.class;
    }

    static JavaType of(Object object) {
        if (null != object) {
            for (JavaType javaType : JavaType.values()) {
                if (!javaType.javaClass.isInstance(object)) continue;
                return javaType;
            }
        }
        return OBJECT;
    }

    JDBCType getJDBCType(SSType sSType, JDBCType jDBCType) {
        return this.jdbcTypeFromJavaType;
    }

    static {
        jvmVersion = 0.0;
    }
}

