/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.model.Association;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.GraphicInfo;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.ServiceTask;
import org.flowable.cmmn.model.Stage;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.service.mapper.InfoMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CmmnDisplayJsonConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnDisplayJsonConverter.class);
    protected CmmnJsonConverter cmmnJsonConverter = new CmmnJsonConverter();
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected List<String> eventElementTypes = new ArrayList<String>();
    protected Map<String, InfoMapper> propertyMappers = new HashMap<String, InfoMapper>();

    public void processCaseElements(AbstractModel caseModel, ObjectNode displayNode, GraphicInfo diagramInfo) {
        ObjectNode elementNode;
        CmmnModel pojoModel = null;
        if (!StringUtils.isEmpty((CharSequence)caseModel.getModelEditorJson())) {
            try {
                JsonNode modelNode = this.objectMapper.readTree(caseModel.getModelEditorJson());
                pojoModel = this.cmmnJsonConverter.convertToCmmnModel(modelNode);
            }
            catch (Exception e) {
                LOGGER.error("Error transforming json to pojo {}", (Object)caseModel.getId(), (Object)e);
            }
        }
        if (pojoModel == null || pojoModel.getLocationMap().isEmpty()) {
            return;
        }
        ArrayNode elementArray = this.objectMapper.createArrayNode();
        ArrayNode flowArray = this.objectMapper.createArrayNode();
        diagramInfo.setX(9999.0);
        diagramInfo.setY(1000.0);
        for (Case caseObject : pojoModel.getCases()) {
            elementNode = this.objectMapper.createObjectNode();
            elementNode.put("id", caseObject.getPlanModel().getId());
            elementNode.put("name", caseObject.getPlanModel().getName());
            GraphicInfo graphicInfo = pojoModel.getGraphicInfo(caseObject.getPlanModel().getId());
            if (graphicInfo != null) {
                this.fillGraphicInfo(elementNode, graphicInfo, true);
                this.fillDiagramInfo(graphicInfo, diagramInfo);
            }
            elementNode.put("type", "PlanModel");
            elementArray.add((JsonNode)elementNode);
            this.processCriteria(caseObject.getPlanModel().getExitCriteria(), "ExitCriterion", pojoModel, elementArray);
            this.processElements(caseObject.getPlanModel().getPlanItems(), pojoModel, elementArray, flowArray, diagramInfo);
        }
        for (Association association : pojoModel.getAssociations()) {
            elementNode = this.objectMapper.createObjectNode();
            elementNode.put("id", association.getId());
            elementNode.put("type", "Association");
            elementNode.put("sourceRef", association.getSourceRef());
            elementNode.put("targetRef", association.getTargetRef());
            List flowInfo = pojoModel.getFlowLocationGraphicInfo(association.getId());
            if (!CollectionUtils.isNotEmpty((Collection)flowInfo)) continue;
            ArrayNode waypointArray = this.objectMapper.createArrayNode();
            for (GraphicInfo graphicInfo : flowInfo) {
                ObjectNode pointNode = this.objectMapper.createObjectNode();
                this.fillGraphicInfo(pointNode, graphicInfo, false);
                waypointArray.add((JsonNode)pointNode);
                this.fillDiagramInfo(graphicInfo, diagramInfo);
            }
            elementNode.set("waypoints", (JsonNode)waypointArray);
            flowArray.add((JsonNode)elementNode);
        }
        displayNode.set("elements", (JsonNode)elementArray);
        displayNode.set("flows", (JsonNode)flowArray);
        displayNode.put("diagramBeginX", diagramInfo.getX());
        displayNode.put("diagramBeginY", diagramInfo.getY());
        displayNode.put("diagramWidth", diagramInfo.getWidth());
        displayNode.put("diagramHeight", diagramInfo.getHeight());
    }

    protected void processElements(List<PlanItem> planItemList, CmmnModel model, ArrayNode elementArray, ArrayNode flowArray, GraphicInfo diagramInfo) {
        for (PlanItem planItem : planItemList) {
            ServiceTask serviceTask;
            ObjectNode elementNode = this.objectMapper.createObjectNode();
            elementNode.put("id", planItem.getId());
            elementNode.put("name", planItem.getName());
            GraphicInfo graphicInfo = model.getGraphicInfo(planItem.getId());
            if (graphicInfo != null) {
                this.fillGraphicInfo(elementNode, graphicInfo, true);
                this.fillDiagramInfo(graphicInfo, diagramInfo);
            }
            PlanItemDefinition planItemDefinition = planItem.getPlanItemDefinition();
            String className = planItemDefinition.getClass().getSimpleName();
            elementNode.put("type", className);
            if (planItemDefinition instanceof ServiceTask && "http".equals((serviceTask = (ServiceTask)planItemDefinition).getType())) {
                elementNode.put("taskType", "http");
            }
            elementArray.add((JsonNode)elementNode);
            this.processCriteria(planItem.getEntryCriteria(), "EntryCriterion", model, elementArray);
            this.processCriteria(planItem.getExitCriteria(), "ExitCriterion", model, elementArray);
            if (!(planItemDefinition instanceof Stage)) continue;
            Stage stage = (Stage)planItemDefinition;
            this.processElements(stage.getPlanItems(), model, elementArray, flowArray, diagramInfo);
        }
    }

    protected void processCriteria(List<Criterion> criteria, String type, CmmnModel model, ArrayNode elementArray) {
        for (Criterion criterion : criteria) {
            ObjectNode criterionNode = this.objectMapper.createObjectNode();
            criterionNode.put("id", criterion.getId());
            criterionNode.put("name", criterion.getName());
            criterionNode.put("type", type);
            GraphicInfo criterionGraphicInfo = model.getGraphicInfo(criterion.getId());
            if (criterionGraphicInfo != null) {
                this.fillGraphicInfo(criterionNode, criterionGraphicInfo, true);
            }
            elementArray.add((JsonNode)criterionNode);
        }
    }

    protected void fillWaypoints(String id, CmmnModel model, ObjectNode elementNode, GraphicInfo diagramInfo) {
        List flowInfo = model.getFlowLocationGraphicInfo(id);
        ArrayNode waypointArray = this.objectMapper.createArrayNode();
        for (GraphicInfo graphicInfo : flowInfo) {
            ObjectNode pointNode = this.objectMapper.createObjectNode();
            this.fillGraphicInfo(pointNode, graphicInfo, false);
            waypointArray.add((JsonNode)pointNode);
            this.fillDiagramInfo(graphicInfo, diagramInfo);
        }
        elementNode.set("waypoints", (JsonNode)waypointArray);
    }

    protected void fillGraphicInfo(ObjectNode elementNode, GraphicInfo graphicInfo, boolean includeWidthAndHeight) {
        this.commonFillGraphicInfo(elementNode, graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight(), includeWidthAndHeight);
    }

    protected void commonFillGraphicInfo(ObjectNode elementNode, double x, double y, double width, double height, boolean includeWidthAndHeight) {
        elementNode.put("x", x);
        elementNode.put("y", y);
        if (includeWidthAndHeight) {
            elementNode.put("width", width);
            elementNode.put("height", height);
        }
    }

    protected void fillDiagramInfo(GraphicInfo graphicInfo, GraphicInfo diagramInfo) {
        double rightX = graphicInfo.getX() + graphicInfo.getWidth();
        double bottomY = graphicInfo.getY() + graphicInfo.getHeight();
        double middleX = graphicInfo.getX() + graphicInfo.getWidth() / 2.0;
        if (middleX < diagramInfo.getX()) {
            diagramInfo.setX(middleX);
        }
        if (graphicInfo.getY() < diagramInfo.getY()) {
            diagramInfo.setY(graphicInfo.getY());
        }
        if (rightX > diagramInfo.getWidth()) {
            diagramInfo.setWidth(rightX);
        }
        if (bottomY > diagramInfo.getHeight()) {
            diagramInfo.setHeight(bottomY);
        }
    }
}

