/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.domain.ModelHistory;
import org.flowable.ui.modeler.repository.ModelHistoryRepository;
import org.flowable.ui.modeler.repository.ModelRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseFlowableModelService {
    protected static final String PROCESS_NOT_FOUND_MESSAGE_KEY = "PROCESS.ERROR.NOT-FOUND";
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    protected ModelHistoryRepository modelHistoryRepository;

    protected Model getModel(String modelId, boolean checkRead, boolean checkEdit) {
        Model model = this.modelRepository.get(modelId);
        if (model == null) {
            NotFoundException processNotFound = new NotFoundException("No model found with the given id: " + modelId);
            processNotFound.setMessageKey(PROCESS_NOT_FOUND_MESSAGE_KEY);
            throw processNotFound;
        }
        return model;
    }

    protected ModelHistory getModelHistory(String modelId, String modelHistoryId, boolean checkRead, boolean checkEdit) {
        Model model = this.getModel(modelId, checkRead, checkEdit);
        ModelHistory modelHistory = this.modelHistoryRepository.get(modelHistoryId);
        if (modelHistory == null || modelHistory.getRemovalDate() != null || !modelHistory.getModelId().equals(model.getId())) {
            throw new NotFoundException("Model history not found: " + modelHistoryId);
        }
        return modelHistory;
    }
}

