/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.repository;

import java.util.HashMap;
import java.util.List;
import org.flowable.ui.common.repository.UuidIdGenerator;
import org.flowable.ui.modeler.domain.ModelInformation;
import org.flowable.ui.modeler.domain.ModelRelation;
import org.flowable.ui.modeler.repository.ModelRelationRepository;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ModelRelationRepositoryImpl
implements ModelRelationRepository {
    private static final String NAMESPACE = "org.flowable.ui.modeler.domain.ModelRelation.";
    @Autowired
    protected SqlSessionTemplate sqlSessionTemplate;
    @Autowired
    protected UuidIdGenerator idGenerator;

    @Override
    public List<ModelRelation> findByParentModelIdAndType(String parentModelId, String type) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("parentModelId", parentModelId);
        params.put("type", type);
        return this.sqlSessionTemplate.selectList("selectModelRelationByParentModelIdAndType", params);
    }

    @Override
    public List<ModelInformation> findModelInformationByParentModelId(String parentModelId) {
        return this.sqlSessionTemplate.selectList("org.flowable.ui.modeler.domain.ModelRelation.selectModelInformationByParentModelId", (Object)parentModelId);
    }

    @Override
    public List<ModelInformation> findModelInformationByChildModelId(String modelId) {
        return this.sqlSessionTemplate.selectList("org.flowable.ui.modeler.domain.ModelRelation.selectModelInformationModelId", (Object)modelId);
    }

    @Override
    public void deleteModelRelationsForParentModel(String parentModelId) {
        this.sqlSessionTemplate.delete("org.flowable.ui.modeler.domain.ModelRelation.deleteModelRelationByParentModelId", (Object)parentModelId);
    }

    @Override
    public void save(ModelRelation modelRelation) {
        if (modelRelation.getId() == null) {
            modelRelation.setId(this.idGenerator.generateId());
            this.sqlSessionTemplate.insert("org.flowable.ui.modeler.domain.ModelRelation.insertModelRelation", (Object)modelRelation);
        } else {
            this.sqlSessionTemplate.update("org.flowable.ui.modeler.domain.ModelRelation.updateModelRelation", (Object)modelRelation);
        }
    }

    @Override
    public void delete(ModelRelation modelRelation) {
        this.sqlSessionTemplate.delete("org.flowable.ui.modeler.domain.ModelRelation.deleteModelRelation", (Object)modelRelation);
    }
}

