/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.repository;

import java.util.HashMap;
import java.util.List;
import org.flowable.ui.common.repository.UuidIdGenerator;
import org.flowable.ui.common.tenant.TenantProvider;
import org.flowable.ui.modeler.domain.ModelHistory;
import org.flowable.ui.modeler.repository.ModelHistoryRepository;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ModelHistoryRepositoryImpl
implements ModelHistoryRepository {
    private static final String NAMESPACE = "org.flowable.ui.modeler.domain.ModelHistory.";
    @Autowired
    protected SqlSessionTemplate sqlSessionTemplate;
    @Autowired
    protected UuidIdGenerator idGenerator;
    @Autowired
    protected TenantProvider tenantProvider;

    @Override
    public ModelHistory get(String id) {
        return (ModelHistory)this.sqlSessionTemplate.selectOne("org.flowable.ui.modeler.domain.ModelHistory.selectModelHistory", (Object)id);
    }

    @Override
    public List<ModelHistory> findByModelTypAndCreatedBy(String createdBy, Integer modelType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelType", modelType);
        params.put("createdBy", createdBy);
        params.put("tenantId", this.tenantProvider.getTenantId());
        return this.sqlSessionTemplate.selectList("org.flowable.ui.modeler.domain.ModelHistory.selectModelHistoryByTypeAndCreatedBy", params);
    }

    @Override
    public List<ModelHistory> findByModelId(String modelId) {
        return this.sqlSessionTemplate.selectList("org.flowable.ui.modeler.domain.ModelHistory.selectModelHistoryByModelId", (Object)modelId);
    }

    @Override
    public void save(ModelHistory modelHistory) {
        modelHistory.setTenantId(this.tenantProvider.getTenantId());
        if (modelHistory.getId() == null) {
            modelHistory.setId(this.idGenerator.generateId());
            this.sqlSessionTemplate.insert("org.flowable.ui.modeler.domain.ModelHistory.insertModelHistory", (Object)modelHistory);
        } else {
            this.sqlSessionTemplate.update("org.flowable.ui.modeler.domain.ModelHistory.updateModelHistory", (Object)modelHistory);
        }
    }

    @Override
    public void delete(ModelHistory modelHistory) {
        this.sqlSessionTemplate.delete("org.flowable.ui.modeler.domain.ModelHistory.deleteModelHistory", (Object)modelHistory);
    }
}

