/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.rest.idm.remote;

import java.util.ArrayList;
import org.flowable.ui.common.model.GroupRepresentation;
import org.flowable.ui.common.model.RemoteGroup;
import org.flowable.ui.common.model.RemoteUser;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class RemoteAccountResource {
    @Autowired
    private RemoteIdmService remoteIdmService;

    @RequestMapping(value={"/rest/account"}, method={RequestMethod.GET}, produces={"application/json"})
    public UserRepresentation getAccount() {
        RemoteUser remoteUser;
        UserRepresentation userRepresentation = null;
        String currentUserId = SecurityUtils.getCurrentUserId();
        if (currentUserId != null && (remoteUser = this.remoteIdmService.getUser(currentUserId)) != null) {
            userRepresentation = new UserRepresentation(remoteUser);
            if (remoteUser.getGroups() != null && remoteUser.getGroups().size() > 0) {
                ArrayList<GroupRepresentation> groups = new ArrayList<GroupRepresentation>();
                for (RemoteGroup remoteGroup : remoteUser.getGroups()) {
                    groups.add(new GroupRepresentation(remoteGroup));
                }
                userRepresentation.setGroups(groups);
            }
            if (remoteUser.getPrivileges() != null && remoteUser.getPrivileges().size() > 0) {
                userRepresentation.setPrivileges(remoteUser.getPrivileges());
            }
        }
        if (userRepresentation != null) {
            return userRepresentation;
        }
        throw new NotFoundException();
    }
}

