/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.properties;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.DefaultPropertySourceFactory;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;

public class BackwardsCompatiblePropertiesLoader
implements EnvironmentPostProcessor,
Ordered {
    public static final int DEFAULT_ORDER = -2147483639;
    private static final PropertySourceFactory DEFAULT_PROPERTY_SOURCE_FACTORY = new DefaultPropertySourceFactory();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String[] DEPRECATED_LOCATIONS = new String[]{"classpath:/META-INF/flowable-ui-app/flowable-ui-app.properties", "classpath:flowable-ui-app.properties", "file:flowable-ui-app.properties"};
    private int order = -2147483639;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        ResourceLoader resourceLoader = application.getResourceLoader();
        if (resourceLoader == null) {
            resourceLoader = new DefaultResourceLoader();
        }
        MutablePropertySources propertySources = environment.getPropertySources();
        for (String location : DEPRECATED_LOCATIONS) {
            try {
                Resource resource = resourceLoader.getResource(location);
                PropertySource propertySource = DEFAULT_PROPERTY_SOURCE_FACTORY.createPropertySource(null, new EncodedResource(resource));
                if (propertySources.contains(propertySource.getName())) {
                    propertySources.replace(propertySource.getName(), propertySource);
                } else {
                    propertySources.addLast(propertySource);
                }
                this.logger.warn("Using deprecated property source {} please switch to using Spring Boot externalized configuration", (Object)propertySource);
            }
            catch (FileNotFoundException | IllegalArgumentException | UnknownHostException ex) {
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info("Properties location [{}] not resolvable: {}", (Object)location, (Object)ex.getMessage());
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to creaty property source", ex);
            }
        }
    }

    public int getOrder() {
        return this.order;
    }
}

