/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.environment;

import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class FlowableDefaultPropertiesEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final int DEFAULT_ORDER = -2147483628;
    private static final String DEFAULT_NAME = "flowable-default";
    private int order = -2147483628;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        new Loader(environment, application.getResourceLoader()).load();
    }

    public int getOrder() {
        return this.order;
    }

    private static class Loader {
        private final ConfigurableEnvironment environment;
        private final ResourceLoader resourceLoader;
        private final List<PropertySourceLoader> propertySourceLoaders;

        Loader(ConfigurableEnvironment environment, ResourceLoader resourceLoader) {
            this.environment = environment;
            this.resourceLoader = resourceLoader == null ? new DefaultResourceLoader() : resourceLoader;
            this.propertySourceLoaders = SpringFactoriesLoader.loadFactories(PropertySourceLoader.class, (ClassLoader)this.getClass().getClassLoader());
        }

        void load() {
            for (PropertySourceLoader loader : this.propertySourceLoaders) {
                for (String extension : loader.getFileExtensions()) {
                    String location = "classpath:/flowable-default." + extension;
                    this.load(location, loader);
                }
            }
        }

        void load(String location, PropertySourceLoader loader) {
            try {
                Resource resource = this.resourceLoader.getResource(location);
                if (!resource.exists()) {
                    return;
                }
                String propertyResourceName = "flowableDefaultConfig: [" + location + "]";
                List propertySources = loader.load(propertyResourceName, resource);
                if (propertySources == null) {
                    return;
                }
                propertySources.forEach(source -> this.environment.getPropertySources().addLast(source));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to load property source from location '" + location + "'", ex);
            }
        }
    }
}

