/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.identitylink.service.impl.persistence.entity;

import java.util.List;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.identitylink.service.IdentityLinkServiceConfiguration;
import org.flowable.identitylink.service.impl.persistence.entity.AbstractEntityManager;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntityManager;
import org.flowable.identitylink.service.impl.persistence.entity.data.HistoricIdentityLinkDataManager;

public class HistoricIdentityLinkEntityManagerImpl
extends AbstractEntityManager<HistoricIdentityLinkEntity>
implements HistoricIdentityLinkEntityManager {
    protected HistoricIdentityLinkDataManager historicIdentityLinkDataManager;

    public HistoricIdentityLinkEntityManagerImpl(IdentityLinkServiceConfiguration identityLinkServiceConfiguration, HistoricIdentityLinkDataManager historicIdentityLinkDataManager) {
        super(identityLinkServiceConfiguration);
        this.historicIdentityLinkDataManager = historicIdentityLinkDataManager;
    }

    @Override
    public HistoricIdentityLinkEntity create() {
        HistoricIdentityLinkEntity identityLinkEntity = (HistoricIdentityLinkEntity)super.create();
        identityLinkEntity.setCreateTime(this.identityLinkServiceConfiguration.getClock().getCurrentTime());
        return identityLinkEntity;
    }

    @Override
    protected DataManager<HistoricIdentityLinkEntity> getDataManager() {
        return this.historicIdentityLinkDataManager;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findHistoricIdentityLinksByTaskId(String taskId) {
        return this.historicIdentityLinkDataManager.findHistoricIdentityLinksByTaskId(taskId);
    }

    @Override
    public List<HistoricIdentityLinkEntity> findHistoricIdentityLinksByProcessInstanceId(String processInstanceId) {
        return this.historicIdentityLinkDataManager.findHistoricIdentityLinksByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<HistoricIdentityLinkEntity> findHistoricIdentityLinksByScopeIdAndScopeType(String scopeId, String scopeType) {
        return this.historicIdentityLinkDataManager.findHistoricIdentityLinksByScopeIdAndScopeType(scopeId, scopeType);
    }

    @Override
    public void deleteHistoricIdentityLinksByTaskId(String taskId) {
        List<HistoricIdentityLinkEntity> identityLinks = this.findHistoricIdentityLinksByTaskId(taskId);
        for (HistoricIdentityLinkEntity identityLink : identityLinks) {
            this.delete(identityLink);
        }
    }

    @Override
    public void deleteHistoricIdentityLinksByProcInstance(String processInstanceId) {
        List<HistoricIdentityLinkEntity> identityLinks = this.historicIdentityLinkDataManager.findHistoricIdentityLinksByProcessInstanceId(processInstanceId);
        for (HistoricIdentityLinkEntity identityLink : identityLinks) {
            this.delete(identityLink);
        }
    }

    @Override
    public void deleteHistoricIdentityLinksByScopeIdAndScopeType(String scopeId, String scopeType) {
        this.historicIdentityLinkDataManager.deleteHistoricIdentityLinksByScopeIdAndType(scopeId, scopeType);
    }

    @Override
    public void deleteHistoricIdentityLinksByScopeDefinitionIdAndScopeType(String scopeDefinitionId, String scopeType) {
        this.historicIdentityLinkDataManager.deleteHistoricIdentityLinksByScopeDefinitionIdAndType(scopeDefinitionId, scopeType);
    }

    public HistoricIdentityLinkDataManager getHistoricIdentityLinkDataManager() {
        return this.historicIdentityLinkDataManager;
    }

    public void setHistoricIdentityLinkDataManager(HistoricIdentityLinkDataManager historicIdentityLinkDataManager) {
        this.historicIdentityLinkDataManager = historicIdentityLinkDataManager;
    }
}

