/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class GetExecutionsVariablesCmd
implements Command<List<VariableInstance>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Set<String> executionIds;

    public GetExecutionsVariablesCmd(Set<String> executionIds) {
        this.executionIds = executionIds;
    }

    public List<VariableInstance> execute(CommandContext commandContext) {
        if (this.executionIds == null) {
            throw new FlowableIllegalArgumentException("executionIds is null");
        }
        if (this.executionIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("Set of executionIds is empty");
        }
        ArrayList<VariableInstance> instances = new ArrayList<VariableInstance>();
        List entities = CommandContextUtil.getVariableService().findVariableInstancesByExecutionIds(this.executionIds);
        for (VariableInstanceEntity entity : entities) {
            entity.getValue();
            instances.add((VariableInstance)entity);
        }
        return instances;
    }
}

