/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.deployer;

import java.util.Collection;
import java.util.List;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.Signal;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.SignalEventSubscriptionEntity;

public class EventSubscriptionManager {
    protected void removeObsoleteEventSubscriptionsImpl(ProcessDefinitionEntity processDefinition, String eventHandlerType) {
        EventSubscriptionService eventSubscriptionService = CommandContextUtil.getEventSubscriptionService();
        List subscriptionsToDelete = eventSubscriptionService.findEventSubscriptionsByTypeAndProcessDefinitionId(eventHandlerType, processDefinition.getId(), processDefinition.getTenantId());
        for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsToDelete) {
            eventSubscriptionService.deleteEventSubscription(eventSubscriptionEntity);
            CountingEntityUtil.handleDeleteEventSubscriptionEntityCount((EventSubscription)eventSubscriptionEntity);
        }
    }

    protected void removeObsoleteMessageEventSubscriptions(ProcessDefinitionEntity previousProcessDefinition) {
        if (previousProcessDefinition != null) {
            this.removeObsoleteEventSubscriptionsImpl(previousProcessDefinition, "message");
        }
    }

    protected void removeObsoleteSignalEventSubScription(ProcessDefinitionEntity previousProcessDefinition) {
        if (previousProcessDefinition != null) {
            this.removeObsoleteEventSubscriptionsImpl(previousProcessDefinition, "signal");
        }
    }

    protected void addMessageEventSubscriptions(ProcessDefinitionEntity processDefinition, Process process, BpmnModel bpmnModel) {
        if (CollectionUtil.isNotEmpty((Collection)process.getFlowElements())) {
            for (FlowElement element : process.getFlowElements()) {
                EventDefinition eventDefinition;
                StartEvent startEvent;
                if (!(element instanceof StartEvent) || !CollectionUtil.isNotEmpty((Collection)(startEvent = (StartEvent)element).getEventDefinitions()) || !((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof MessageEventDefinition)) continue;
                MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
                this.insertMessageEvent(messageEventDefinition, startEvent, processDefinition, bpmnModel);
            }
        }
    }

    protected void insertMessageEvent(MessageEventDefinition messageEventDefinition, StartEvent startEvent, ProcessDefinitionEntity processDefinition, BpmnModel bpmnModel) {
        CommandContext commandContext = Context.getCommandContext();
        EventSubscriptionService eventSubscriptionService = CommandContextUtil.getEventSubscriptionService(commandContext);
        List subscriptionsForSameMessageName = eventSubscriptionService.findEventSubscriptionsByName("message", messageEventDefinition.getMessageRef(), processDefinition.getTenantId());
        for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsForSameMessageName) {
            if (eventSubscriptionEntity.getProcessInstanceId() != null && !eventSubscriptionEntity.getProcessInstanceId().isEmpty()) continue;
            throw new FlowableException("Cannot deploy process definition '" + processDefinition.getResourceName() + "': there already is a message event subscription for the message with name '" + messageEventDefinition.getMessageRef() + "'.");
        }
        MessageEventSubscriptionEntity newSubscription = eventSubscriptionService.createMessageEventSubscription();
        newSubscription.setEventName(messageEventDefinition.getMessageRef());
        newSubscription.setActivityId(startEvent.getId());
        newSubscription.setConfiguration(processDefinition.getId());
        newSubscription.setProcessDefinitionId(processDefinition.getId());
        if (processDefinition.getTenantId() != null) {
            newSubscription.setTenantId(processDefinition.getTenantId());
        }
        eventSubscriptionService.insertEventSubscription((EventSubscriptionEntity)newSubscription);
        CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)newSubscription);
    }

    protected void addSignalEventSubscriptions(CommandContext commandContext, ProcessDefinitionEntity processDefinition, Process process, BpmnModel bpmnModel) {
        if (CollectionUtil.isNotEmpty((Collection)process.getFlowElements())) {
            for (FlowElement element : process.getFlowElements()) {
                EventDefinition eventDefinition;
                StartEvent startEvent;
                if (!(element instanceof StartEvent) || !CollectionUtil.isNotEmpty((Collection)(startEvent = (StartEvent)element).getEventDefinitions()) || !((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof SignalEventDefinition)) continue;
                SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
                SignalEventSubscriptionEntity subscriptionEntity = CommandContextUtil.getEventSubscriptionService(commandContext).createSignalEventSubscription();
                Signal signal = bpmnModel.getSignal(signalEventDefinition.getSignalRef());
                if (signal != null) {
                    subscriptionEntity.setEventName(signal.getName());
                } else {
                    subscriptionEntity.setEventName(signalEventDefinition.getSignalRef());
                }
                subscriptionEntity.setActivityId(startEvent.getId());
                subscriptionEntity.setProcessDefinitionId(processDefinition.getId());
                if (processDefinition.getTenantId() != null) {
                    subscriptionEntity.setTenantId(processDefinition.getTenantId());
                }
                CommandContextUtil.getEventSubscriptionService(commandContext).insertEventSubscription((EventSubscriptionEntity)subscriptionEntity);
                CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)subscriptionEntity);
            }
        }
    }
}

