/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.FieldExtension;
import org.flowable.bpmn.model.Task;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.api.DmnRuleService;
import org.flowable.dmn.api.ExecuteDecisionBuilder;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.DelegateHelper;
import org.flowable.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.DynamicPropertyUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;

public class DmnActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected static final String EXPRESSION_DECISION_TABLE_REFERENCE_KEY = "decisionTableReferenceKey";
    protected static final String EXPRESSION_DECISION_TABLE_THROW_ERROR_FLAG = "decisionTaskThrowErrorOnNoHits";
    protected static final String EXPRESSION_DECISION_TABLE_FALLBACK_TO_DEFAULT_TENANT = "fallbackToDefaultTenant";
    protected Task task;

    public DmnActivityBehavior(Task task) {
        this.task = task;
    }

    @Override
    public void execute(DelegateExecution execution) {
        FieldExtension fieldExtension = DelegateHelper.getFlowElementField(execution, EXPRESSION_DECISION_TABLE_REFERENCE_KEY);
        if (fieldExtension == null || (fieldExtension.getStringValue() == null || fieldExtension.getStringValue().length() == 0) && (fieldExtension.getExpression() == null || fieldExtension.getExpression().length() == 0)) {
            throw new FlowableException("decisionTableReferenceKey is a required field extension for the dmn task " + this.task.getId());
        }
        String activeDecisionTableKey = null;
        activeDecisionTableKey = fieldExtension.getExpression() != null && fieldExtension.getExpression().length() > 0 ? fieldExtension.getExpression() : fieldExtension.getStringValue();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        if (processEngineConfiguration.isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(this.task.getId(), execution.getProcessDefinitionId());
            activeDecisionTableKey = DynamicPropertyUtil.getActiveValue(activeDecisionTableKey, "dmnTaskDecisionTableKey", taskElementProperties);
        }
        String finaldecisionTableKeyValue = null;
        Object decisionTableKeyValue = expressionManager.createExpression(activeDecisionTableKey).getValue((VariableContainer)execution);
        if (decisionTableKeyValue != null) {
            if (decisionTableKeyValue instanceof String) {
                finaldecisionTableKeyValue = (String)decisionTableKeyValue;
            } else {
                throw new FlowableIllegalArgumentException("decisionTableReferenceKey expression does not resolve to a string: " + decisionTableKeyValue);
            }
        }
        if (finaldecisionTableKeyValue == null || finaldecisionTableKeyValue.length() == 0) {
            throw new FlowableIllegalArgumentException("decisionTableReferenceKey expression resolves to an empty value: " + decisionTableKeyValue);
        }
        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(execution.getProcessDefinitionId());
        Deployment deployment = (Deployment)CommandContextUtil.getDeploymentEntityManager().findById(processDefinition.getDeploymentId());
        DmnRuleService ruleService = CommandContextUtil.getDmnRuleService();
        ExecuteDecisionBuilder executeDecisionBuilder = ruleService.createExecuteDecisionBuilder().decisionKey(finaldecisionTableKeyValue).parentDeploymentId(deployment.getParentDeploymentId()).instanceId(execution.getProcessInstanceId()).executionId(execution.getId()).activityId(this.task.getId()).variables(execution.getVariables()).tenantId(execution.getTenantId());
        this.applyFallbackToDefaultTenant(execution, executeDecisionBuilder);
        DecisionExecutionAuditContainer decisionExecutionAuditContainer = executeDecisionBuilder.executeWithAuditTrail();
        if (decisionExecutionAuditContainer.isFailed().booleanValue()) {
            throw new FlowableException("DMN decision table with key " + finaldecisionTableKeyValue + " execution failed. Cause: " + decisionExecutionAuditContainer.getExceptionMessage());
        }
        FieldExtension throwErrorFieldExtension = DelegateHelper.getFlowElementField(execution, EXPRESSION_DECISION_TABLE_THROW_ERROR_FLAG);
        if (throwErrorFieldExtension != null) {
            String throwErrorString = null;
            if (StringUtils.isNotEmpty((CharSequence)throwErrorFieldExtension.getStringValue())) {
                throwErrorString = throwErrorFieldExtension.getStringValue();
            } else if (StringUtils.isNotEmpty((CharSequence)throwErrorFieldExtension.getExpression())) {
                throwErrorString = throwErrorFieldExtension.getExpression();
            }
            if (decisionExecutionAuditContainer.getDecisionResult().isEmpty() && throwErrorString != null) {
                Expression expression;
                Object expressionValue;
                if ("true".equalsIgnoreCase(throwErrorString)) {
                    throw new FlowableException("DMN decision table with key " + finaldecisionTableKeyValue + " did not hit any rules for the provided input.");
                }
                if (!"false".equalsIgnoreCase(throwErrorString) && (expressionValue = (expression = expressionManager.createExpression(throwErrorString)).getValue((VariableContainer)execution)) instanceof Boolean && ((Boolean)expressionValue).booleanValue()) {
                    throw new FlowableException("DMN decision table with key " + finaldecisionTableKeyValue + " did not hit any rules for the provided input.");
                }
            }
        }
        this.setVariablesOnExecution(decisionExecutionAuditContainer.getDecisionResult(), finaldecisionTableKeyValue, execution, processEngineConfiguration.getObjectMapper());
        this.leave(execution);
    }

    protected void applyFallbackToDefaultTenant(DelegateExecution execution, ExecuteDecisionBuilder executeDecisionBuilder) {
        String fallbackToDefaultTenant;
        FieldExtension fallbackfieldExtension = DelegateHelper.getFlowElementField(execution, EXPRESSION_DECISION_TABLE_FALLBACK_TO_DEFAULT_TENANT);
        if (fallbackfieldExtension != null && fallbackfieldExtension.getStringValue() != null && fallbackfieldExtension.getStringValue().length() != 0 && StringUtils.isNotEmpty((CharSequence)(fallbackToDefaultTenant = fallbackfieldExtension.getStringValue())) && Boolean.parseBoolean(fallbackToDefaultTenant)) {
            executeDecisionBuilder.fallbackToDefaultTenant();
        }
    }

    protected void setVariablesOnExecution(List<Map<String, Object>> executionResult, String decisionKey, DelegateExecution execution, ObjectMapper objectMapper) {
        if (executionResult == null || executionResult.isEmpty()) {
            return;
        }
        if (executionResult.size() > 1) {
            ArrayNode ruleResultNode = objectMapper.createArrayNode();
            for (Map<String, Object> ruleResult : executionResult) {
                ObjectNode outputResultNode = objectMapper.createObjectNode();
                for (Map.Entry<String, Object> outputResult : ruleResult.entrySet()) {
                    outputResultNode.set(outputResult.getKey(), (JsonNode)objectMapper.convertValue(outputResult.getValue(), JsonNode.class));
                }
                ruleResultNode.add((JsonNode)outputResultNode);
            }
            execution.setVariable(decisionKey, ruleResultNode);
        } else {
            Map<String, Object> ruleResult = executionResult.get(0);
            for (Map.Entry<String, Object> outputResult : ruleResult.entrySet()) {
                execution.setVariable(outputResult.getKey(), outputResult.getValue());
            }
        }
    }
}

