# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['CollateralCriteriaBase']


class CollateralCriteriaBase(BaseDataClass):
  """
  Represents a set of criteria used to specify and describe collateral.
  """
  issuer: List[IssuerCriteria] = Field([], description="Represents a filter based criteria related to the issuer.")
  """
  Represents a filter based criteria related to the issuer.
  """
  asset: List[AssetCriteria] = Field([], description="Represents a filter based on the criteria related to the asset.")
  """
  Represents a filter based on the criteria related to the asset.
  """
  appliesTo: List[CounterpartyRoleEnum] = Field([], description="Specifies which of the two counterparties the criteria applies to (either one or both counterparties). This attribute is optional, in case the applicable party is already specified elsewhere within a party election.")
  """
  Specifies which of the two counterparties the criteria applies to (either one or both counterparties). This attribute is optional, in case the applicable party is already specified elsewhere within a party election.
  """
  @rosetta_condition
  def cardinality_appliesTo(self):
    return check_cardinality(self.appliesTo, 0, 2)
  

from cdm.product.collateral.IssuerCriteria import IssuerCriteria
from cdm.product.collateral.AssetCriteria import AssetCriteria
from cdm.base.staticdata.party.CounterpartyRoleEnum import CounterpartyRoleEnum

CollateralCriteriaBase.update_forward_refs()
