# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['Agreement']


class Agreement(BaseDataClass):
  """
  Specification of the standard set of terms that define a legal agreement.
  """
  creditSupportAgreementElections: Optional[CreditSupportAgreementElections] = Field(None, description="Elections to specify a Credit Support Annex or Credit Support Deed for Intial or Variation Margin.")
  """
  Elections to specify a Credit Support Annex or Credit Support Deed for Intial or Variation Margin.
  """
  collateralTransferAgreementElections: Optional[CollateralTransferAgreementElections] = Field(None, description="Elections to specify a Collateral Transfer Agreement.")
  """
  Elections to specify a Collateral Transfer Agreement.
  """
  securityAgreementElections: Optional[SecurityAgreementElections] = Field(None, description="Elections to specify a Security agreement.")
  """
  Elections to specify a Security agreement.
  """
  masterAgreementSchedule: Optional[MasterAgreementSchedule] = Field(None, description="Elections to specify a Master Agreement Schedule.")
  """
  Elections to specify a Master Agreement Schedule.
  """
  transactionAdditionalTerms: Optional[TransactionAdditionalTerms] = Field(None, description="Any additional terms which mainly intend to specify the extraordinary events that may affect a trade and the related contractual rights and obligation of the parties when this happens")
  """
  Any additional terms which mainly intend to specify the extraordinary events that may affect a trade and the related contractual rights and obligation of the parties when this happens
  """
  
  @rosetta_condition
  def condition_0_(self):
    return self.check_one_of_constraint('creditSupportAgreementElections', 'collateralTransferAgreementElections', 'securityAgreementElections', 'masterAgreementSchedule', 'transactionAdditionalTerms', necessity=True)

from cdm.legaldocumentation.csa.CreditSupportAgreementElections import CreditSupportAgreementElections
from cdm.legaldocumentation.csa.CollateralTransferAgreementElections import CollateralTransferAgreementElections
from cdm.legaldocumentation.csa.SecurityAgreementElections import SecurityAgreementElections
from cdm.legaldocumentation.master.MasterAgreementSchedule import MasterAgreementSchedule
from cdm.legaldocumentation.master.TransactionAdditionalTerms import TransactionAdditionalTerms

Agreement.update_forward_refs()
