# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['AvailableInventoryRecord']

from cdm.event.position.InventoryRecord import InventoryRecord

class AvailableInventoryRecord(InventoryRecord):
  """
  An individual piece of available inventory. This represents a single security and its associated criteria. The criteria are used to describe any restrictions on the securities.
  """
  expirationDateTime: Optional[datetime] = Field(None, description="There may be a set period/time restriction associated to the security.")
  """
  There may be a set period/time restriction associated to the security.
  """
  collateral: List[CollateralProvisions] = Field([], description="The type of collateral can often be required when determining if the piece of availability being described is suitable for a party.")
  """
  The type of collateral can often be required when determining if the piece of availability being described is suitable for a party.
  """
  partyRole: List[PartyRole] = Field([], description="An individual security may be held by several agents. Including the party role at this level allows us to reference the party holding this specific item.")
  """
  An individual security may be held by several agents. Including the party role at this level allows us to reference the party holding this specific item.
  """
  availableQuantity: Optional[Quantity] = Field(None, description="The quantity of the security that is available")
  """
  The quantity of the security that is available
  """
  interestRate: Optional[Price] = Field(None, description="An optional element which can be used to hold a rate associated to this piece of availability.")
  """
  An optional element which can be used to hold a rate associated to this piece of availability.
  """
  
  @rosetta_condition
  def condition_0_InterestRate(self):
    """
    Where an Interest Rate has been specified then the Price Type must be set to interest rate
    """
    def _then_fn0():
      return all_elements(_resolve_rosetta_attr(_resolve_rosetta_attr(self, "interestRate"), "priceType"), "=", _resolve_rosetta_attr(PriceTypeEnum, "INTEREST_RATE"))
    
    def _else_fn0():
      return True
    
    return if_cond_fn(((_resolve_rosetta_attr(self, "interestRate")) is not None), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_1_ValidPartyRole(self):
    """
    Restrict roles to be only those that would be associated to an individual piece of availability
    """
    return IsValidPartyRole(_resolve_rosetta_attr(self, "partyRole"), [_resolve_rosetta_attr(PartyRoleEnum, "AGENT_LENDER"), _resolve_rosetta_attr(PartyRoleEnum, "BENEFICIAL_OWNER"), _resolve_rosetta_attr(PartyRoleEnum, "CUSTODIAN"), _resolve_rosetta_attr(PartyRoleEnum, "LENDER")])

from cdm.product.collateral.CollateralProvisions import CollateralProvisions
from cdm.base.staticdata.party.PartyRole import PartyRole
from cdm.base.math.Quantity import Quantity
from cdm.observable.asset.Price import Price
from cdm.observable.asset.PriceTypeEnum import PriceTypeEnum
from cdm.event.position.functions.IsValidPartyRole import IsValidPartyRole
from cdm.base.staticdata.party.PartyRoleEnum import PartyRoleEnum

AvailableInventoryRecord.update_forward_refs()
