/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="CashSettlementMethodEnum")
public enum CashSettlementMethodEnum {
    CASH_PRICE_METHOD("CashPriceMethod"),
    CASH_PRICE_ALTERNATE_METHOD("CashPriceAlternateMethod"),
    PAR_YIELD_CURVE_ADJUSTED_METHOD("ParYieldCurveAdjustedMethod"),
    ZERO_COUPON_YIELD_ADJUSTED_METHOD("ZeroCouponYieldAdjustedMethod"),
    PAR_YIELD_CURVE_UNADJUSTED_METHOD("ParYieldCurveUnadjustedMethod"),
    CROSS_CURRENCY_METHOD("CrossCurrencyMethod"),
    COLLATERALIZED_CASH_PRICE_METHOD("CollateralizedCashPriceMethod"),
    MID_MARKET_INDICATIVE_QUOTATIONS("MidMarketIndicativeQuotations"),
    MID_MARKET_INDICATIVE_QUOTATIONS_ALTERNATE("MidMarketIndicativeQuotationsAlternate"),
    MID_MARKET_CALCULATION_AGENT_DETERMINATION("MidMarketCalculationAgentDetermination"),
    REPLACEMENT_VALUE_FIRM_QUOTATIONS("ReplacementValueFirmQuotations"),
    REPLACEMENT_VALUE_CALCULATION_AGENT_DETERMINATION("ReplacementValueCalculationAgentDetermination");

    private static Map<String, CashSettlementMethodEnum> values;
    private final String rosettaName;
    private final String displayName;

    private CashSettlementMethodEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private CashSettlementMethodEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static CashSettlementMethodEnum fromDisplayName(String name) {
        CashSettlementMethodEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, CashSettlementMethodEnum> map = new ConcurrentHashMap<String, CashSettlementMethodEnum>();
        for (CashSettlementMethodEnum instance : CashSettlementMethodEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

