/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;

@RosettaDataRule(value="PriceScheduleChoice")
@ImplementedBy(value=Default.class)
public interface PriceScheduleChoice
extends Validator<PriceSchedule> {
    public static final String NAME = "PriceScheduleChoice";
    public static final String DEFINITION = "optional choice cashPrice, arithmeticOperator, composite";

    public ValidationResult<PriceSchedule> validate(RosettaPath var1, PriceSchedule var2);

    public static class NoOp
    implements PriceScheduleChoice {
        @Override
        public ValidationResult<PriceSchedule> validate(RosettaPath path, PriceSchedule priceSchedule) {
            return ValidationResult.success((String)PriceScheduleChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceScheduleChoice.DEFINITION);
        }
    }

    public static class Default
    implements PriceScheduleChoice {
        @Override
        public ValidationResult<PriceSchedule> validate(RosettaPath path, PriceSchedule priceSchedule) {
            ComparisonResult result = this.executeDataRule(priceSchedule);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PriceScheduleChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceScheduleChoice.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PriceScheduleChoice failed.";
            }
            return ValidationResult.failure((String)PriceScheduleChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceScheduleChoice.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PriceSchedule priceSchedule) {
            try {
                ComparisonResult result = ExpressionOperators.choice((Mapper)MapperS.of((Object)priceSchedule), Arrays.asList("cashPrice", "arithmeticOperator", "composite"), (ValidationResult.ChoiceRuleValidationMethod)ValidationResult.ChoiceRuleValidationMethod.OPTIONAL);
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

