/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.functions.VectorScalarOperation;
import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.calculatedrate.ObservationParameters;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=ProcessObservationsDefault.class)
public abstract class ProcessObservations
implements RosettaFunction {
    @Inject
    protected VectorScalarOperation vectorScalarOperation;

    public List<BigDecimal> evaluate(FloatingRateCalculationParameters calculationParameters, List<BigDecimal> rawObservations) {
        List<BigDecimal> processedObservations = this.doEvaluate(calculationParameters, rawObservations);
        return processedObservations;
    }

    protected abstract List<BigDecimal> doEvaluate(FloatingRateCalculationParameters var1, List<BigDecimal> var2);

    protected abstract Mapper<? extends ObservationParameters> params(FloatingRateCalculationParameters var1, List<BigDecimal> var2);

    protected abstract Mapper<BigDecimal> cap(FloatingRateCalculationParameters var1, List<BigDecimal> var2);

    protected abstract Mapper<BigDecimal> floor(FloatingRateCalculationParameters var1, List<BigDecimal> var2);

    protected abstract Mapper<BigDecimal> cappedObservations(FloatingRateCalculationParameters var1, List<BigDecimal> var2);

    protected abstract Mapper<BigDecimal> flooredObservations(FloatingRateCalculationParameters var1, List<BigDecimal> var2);

    public static class ProcessObservationsDefault
    extends ProcessObservations {
        @Override
        protected List<BigDecimal> doEvaluate(FloatingRateCalculationParameters calculationParameters, List<BigDecimal> rawObservations) {
            ArrayList<BigDecimal> processedObservations = new ArrayList<BigDecimal>();
            return this.assignOutput(processedObservations, calculationParameters, rawObservations);
        }

        protected List<BigDecimal> assignOutput(List<BigDecimal> processedObservations, FloatingRateCalculationParameters calculationParameters, List<BigDecimal> rawObservations) {
            List addVar = MapperC.of((List)this.flooredObservations(calculationParameters, rawObservations).getMulti()).getMulti();
            processedObservations.addAll(addVar);
            return processedObservations;
        }

        @Override
        protected Mapper<? extends ObservationParameters> params(FloatingRateCalculationParameters calculationParameters, List<BigDecimal> rawObservations) {
            return MapperS.of((Object)calculationParameters).map("getObservationParameters", floatingRateCalculationParameters -> floatingRateCalculationParameters.getObservationParameters());
        }

        @Override
        protected Mapper<BigDecimal> cap(FloatingRateCalculationParameters calculationParameters, List<BigDecimal> rawObservations) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((ObservationParameters)this.params(calculationParameters, rawObservations).get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((ObservationParameters)this.params(calculationParameters, rawObservations).get())).map("getObservationCapRate", observationParameters -> observationParameters.getObservationCapRate());
                }
                return null;
            });
        }

        @Override
        protected Mapper<BigDecimal> floor(FloatingRateCalculationParameters calculationParameters, List<BigDecimal> rawObservations) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((ObservationParameters)this.params(calculationParameters, rawObservations).get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((ObservationParameters)this.params(calculationParameters, rawObservations).get())).map("getObservationFloorRate", observationParameters -> observationParameters.getObservationFloorRate());
                }
                return null;
            });
        }

        @Override
        protected Mapper<BigDecimal> cappedObservations(FloatingRateCalculationParameters calculationParameters, List<BigDecimal> rawObservations) {
            return MapperUtils.runMulti(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.cap(calculationParameters, rawObservations).get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperC.of(this.vectorScalarOperation.evaluate((ArithmeticOperationEnum)((Object)((Object)MapperS.of((Object)((Object)ArithmeticOperationEnum.MIN)).get())), MapperC.of((List)rawObservations).getMulti(), (BigDecimal)MapperS.of((Object)((BigDecimal)this.cap(calculationParameters, rawObservations).get())).get()));
                }
                return MapperC.of((List)rawObservations);
            });
        }

        @Override
        protected Mapper<BigDecimal> flooredObservations(FloatingRateCalculationParameters calculationParameters, List<BigDecimal> rawObservations) {
            return MapperUtils.runMulti(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.floor(calculationParameters, rawObservations).get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperC.of(this.vectorScalarOperation.evaluate((ArithmeticOperationEnum)((Object)((Object)MapperS.of((Object)((Object)ArithmeticOperationEnum.MAX)).get())), MapperC.of((List)this.cappedObservations(calculationParameters, rawObservations).getMulti()).getMulti(), (BigDecimal)MapperS.of((Object)((BigDecimal)this.floor(calculationParameters, rawObservations).get())).get()));
                }
                return MapperC.of((List)this.cappedObservations(calculationParameters, rawObservations).getMulti());
            });
        }
    }
}

