/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="MatrixTypeEnum")
public enum MatrixTypeEnum {
    CREDIT_DERIVATIVES_PHYSICAL_SETTLEMENT_MATRIX("CreditDerivativesPhysicalSettlementMatrix"),
    EQUITY_DERIVATIVES_MATRIX("EquityDerivativesMatrix"),
    SETTLEMENT_MATRIX("SettlementMatrix");

    private static Map<String, MatrixTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private MatrixTypeEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private MatrixTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static MatrixTypeEnum fromDisplayName(String name) {
        MatrixTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, MatrixTypeEnum> map = new ConcurrentHashMap<String, MatrixTypeEnum>();
        for (MatrixTypeEnum instance : MatrixTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

