/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.workflow.functions;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Account;
import cdm.base.staticdata.party.Party;
import cdm.event.common.ActionEnum;
import cdm.event.common.BusinessEvent;
import cdm.event.workflow.EventTimestamp;
import cdm.event.workflow.MessageInformation;
import cdm.event.workflow.WorkflowStep;
import cdm.event.workflow.metafields.ReferenceWithMetaWorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_AcceptedWorkflowStepDefault.class)
public abstract class Create_AcceptedWorkflowStep
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;

    public WorkflowStep evaluate(MessageInformation messageInformation, List<? extends EventTimestamp> timestamp, List<? extends Identifier> eventIdentifier, List<? extends Party> party, List<? extends Account> account, WorkflowStep proposedWorkflowStep, BusinessEvent businessEvent) {
        WorkflowStep acceptedWorkflowStep;
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)proposedWorkflowStep).map("getProposedEvent", workflowStep -> workflowStep.getProposedEvent())), "The previous step being accepted must be a proposed step containing an instruction.");
        this.conditionValidator.validate(() -> ExpressionOperators.notEqual((Mapper)MapperS.of((Object)proposedWorkflowStep).map("getAction", workflowStep -> workflowStep.getAction()), (Mapper)MapperS.of((Object)((Object)ActionEnum.CANCEL)), (CardinalityOperator)CardinalityOperator.Any), "You cannot accept a business event on a cancelled previous step.");
        this.conditionValidator.validate(() -> ExpressionOperators.notEqual((Mapper)MapperS.of((Object)proposedWorkflowStep).map("getRejected", workflowStep -> workflowStep.getRejected()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.Any), "The previous step cannot be rejected.");
        WorkflowStep.WorkflowStepBuilder acceptedWorkflowStepBuilder = this.doEvaluate(messageInformation, timestamp, eventIdentifier, party, account, proposedWorkflowStep, businessEvent);
        if (acceptedWorkflowStepBuilder == null) {
            acceptedWorkflowStep = null;
        } else {
            acceptedWorkflowStep = acceptedWorkflowStepBuilder.build();
            this.objectValidator.validate(WorkflowStep.class, (RosettaModelObject)acceptedWorkflowStep);
        }
        return acceptedWorkflowStep;
    }

    protected abstract WorkflowStep.WorkflowStepBuilder doEvaluate(MessageInformation var1, List<? extends EventTimestamp> var2, List<? extends Identifier> var3, List<? extends Party> var4, List<? extends Account> var5, WorkflowStep var6, BusinessEvent var7);

    public static class Create_AcceptedWorkflowStepDefault
    extends Create_AcceptedWorkflowStep {
        @Override
        protected WorkflowStep.WorkflowStepBuilder doEvaluate(MessageInformation messageInformation, List<? extends EventTimestamp> timestamp, List<? extends Identifier> eventIdentifier, List<? extends Party> party, List<? extends Account> account, WorkflowStep proposedWorkflowStep, BusinessEvent businessEvent) {
            WorkflowStep.WorkflowStepBuilder acceptedWorkflowStep = WorkflowStep.builder();
            return this.assignOutput(acceptedWorkflowStep, messageInformation, timestamp, eventIdentifier, party, account, proposedWorkflowStep, businessEvent);
        }

        protected WorkflowStep.WorkflowStepBuilder assignOutput(WorkflowStep.WorkflowStepBuilder acceptedWorkflowStep, MessageInformation messageInformation, List<? extends EventTimestamp> timestamp, List<? extends Identifier> eventIdentifier, List<? extends Party> party, List<? extends Account> account, WorkflowStep proposedWorkflowStep, BusinessEvent businessEvent) {
            acceptedWorkflowStep.setMessageInformation((MessageInformation)MapperS.of((Object)messageInformation).get());
            acceptedWorkflowStep.addTimestamp(MapperC.of(timestamp).getMulti());
            acceptedWorkflowStep.addEventIdentifier(MapperC.of(eventIdentifier).getMulti());
            acceptedWorkflowStep.addParty(MapperC.of(party).getMulti());
            acceptedWorkflowStep.addAccount(MapperC.of(account).getMulti());
            acceptedWorkflowStep.setPreviousWorkflowStep(ReferenceWithMetaWorkflowStep.builder().setGlobalReference(Optional.ofNullable((WorkflowStep)MapperS.of((Object)proposedWorkflowStep).get()).map(r -> r.getMeta()).map(m -> m.getGlobalKey()).orElse(null)).setExternalReference(Optional.ofNullable((WorkflowStep)MapperS.of((Object)proposedWorkflowStep).get()).map(r -> r.getMeta()).map(m -> m.getExternalKey()).orElse(null)).build());
            acceptedWorkflowStep.setBusinessEvent((BusinessEvent)MapperS.of((Object)businessEvent).get());
            return Optional.ofNullable(acceptedWorkflowStep).map(o -> o.prune()).orElse(null);
        }
    }
}

