/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.QuantitySchedule;
import cdm.base.math.functions.FilterQuantityByCurrency;
import cdm.event.common.Trade;
import cdm.event.position.functions.InterpolateForwardRate;
import cdm.product.template.ForwardPayout;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=FxMarkToMarketDefault.class)
public abstract class FxMarkToMarket
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected FilterQuantityByCurrency filterQuantityByCurrency;
    @Inject
    protected InterpolateForwardRate interpolateForwardRate;

    public BigDecimal evaluate(Trade trade) {
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout())), "The forwardPayout on the contract must exist.");
        BigDecimal value = this.doEvaluate(trade);
        return value;
    }

    protected abstract BigDecimal doEvaluate(Trade var1);

    protected abstract Mapper<? extends ForwardPayout> forwardPayout(Trade var1);

    protected abstract Mapper<String> quotedCurrency(Trade var1);

    protected abstract Mapper<String> baseCurrency(Trade var1);

    protected abstract Mapper<? extends NonNegativeQuantitySchedule> quantities(Trade var1);

    protected abstract Mapper<BigDecimal> quotedQuantity(Trade var1);

    protected abstract Mapper<BigDecimal> baseQuantity(Trade var1);

    protected abstract Mapper<BigDecimal> interpolatedRate(Trade var1);

    public static class FxMarkToMarketDefault
    extends FxMarkToMarket {
        @Override
        protected BigDecimal doEvaluate(Trade trade) {
            BigDecimal value = null;
            return this.assignOutput(value, trade);
        }

        protected BigDecimal assignOutput(BigDecimal value, Trade trade) {
            value = (BigDecimal)MapperMaths.multiply((Mapper)MapperMaths.subtract((Mapper)MapperMaths.divide((Mapper)MapperS.of((Object)((BigDecimal)this.quotedQuantity(trade).get())), (Mapper)MapperS.of((Object)((BigDecimal)this.interpolatedRate(trade).get()))), (Mapper)MapperS.of((Object)((BigDecimal)this.baseQuantity(trade).get()))), (Mapper)MapperS.of((Object)((BigDecimal)this.interpolatedRate(trade).get()))).get();
            return value;
        }

        @Override
        protected Mapper<? extends ForwardPayout> forwardPayout(Trade trade) {
            return MapperS.of((Object)((ForwardPayout)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()));
        }

        @Override
        protected Mapper<String> quotedCurrency(Trade trade) {
            return MapperS.of((Object)((String)ExpressionOperators.distinct((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()).map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue())).get()));
        }

        @Override
        protected Mapper<String> baseCurrency(Trade trade) {
            return MapperS.of((Object)((String)ExpressionOperators.distinct((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()).map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue())).get()));
        }

        @Override
        protected Mapper<? extends NonNegativeQuantitySchedule> quantities(Trade trade) {
            return MapperS.of((Object)((TradeLot)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("getValue", _f -> _f.getValue());
        }

        @Override
        protected Mapper<BigDecimal> quotedQuantity(Trade trade) {
            return MapperS.of((Object)((QuantitySchedule)MapperC.of(this.filterQuantityByCurrency.evaluate(MapperC.of((List)this.quantities(trade).getMulti()).getMulti(), (String)MapperS.of((Object)((String)this.quotedCurrency(trade).get())).get())).get())).map("getValue", measureBase -> measureBase.getValue());
        }

        @Override
        protected Mapper<BigDecimal> baseQuantity(Trade trade) {
            return MapperS.of((Object)((QuantitySchedule)MapperC.of(this.filterQuantityByCurrency.evaluate(MapperC.of((List)this.quantities(trade).getMulti()).getMulti(), (String)MapperS.of((Object)((String)this.baseCurrency(trade).get())).get())).get())).map("getValue", measureBase -> measureBase.getValue());
        }

        @Override
        protected Mapper<BigDecimal> interpolatedRate(Trade trade) {
            return MapperS.of((Object)this.interpolateForwardRate.evaluate((ForwardPayout)MapperS.of((Object)((ForwardPayout)this.forwardPayout(trade).get())).get()));
        }
    }
}

