/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.TransferBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="TransferBaseFinancialUnitExists")
@ImplementedBy(value=Default.class)
public interface TransferBaseFinancialUnitExists
extends Validator<TransferBase> {
    public static final String NAME = "TransferBaseFinancialUnitExists";
    public static final String DEFINITION = "if observable exists then quantity -> unit -> financialUnit exists";

    public ValidationResult<TransferBase> validate(RosettaPath var1, TransferBase var2);

    public static class NoOp
    implements TransferBaseFinancialUnitExists {
        @Override
        public ValidationResult<TransferBase> validate(RosettaPath path, TransferBase transferBase) {
            return ValidationResult.success((String)TransferBaseFinancialUnitExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TransferBase", (RosettaPath)path, (String)TransferBaseFinancialUnitExists.DEFINITION);
        }
    }

    public static class Default
    implements TransferBaseFinancialUnitExists {
        @Override
        public ValidationResult<TransferBase> validate(RosettaPath path, TransferBase transferBase) {
            ComparisonResult result = this.executeDataRule(transferBase);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)TransferBaseFinancialUnitExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TransferBase", (RosettaPath)path, (String)TransferBaseFinancialUnitExists.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition TransferBaseFinancialUnitExists failed.";
            }
            return ValidationResult.failure((String)TransferBaseFinancialUnitExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TransferBase", (RosettaPath)path, (String)TransferBaseFinancialUnitExists.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(TransferBase transferBase) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)transferBase).map("getObservable", _transferBase -> _transferBase.getObservable())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)transferBase).map("getQuantity", _transferBase -> _transferBase.getQuantity()).map("getUnit", measureBase -> measureBase.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

